<?php
/**
* Czech (cs) translation file.
*  
* @author Nick Korbel <lqqkout13@users.sourceforge.net>
* @translator <jindrich@natur.cuni.cz>
* @version 05-13-06
* @package Languages
*
* Copyright (C) 2003 - 2007 phpScheduleIt
* License: GPL, see LICENSE
*/
///////////////////////////////////////////////////////////
// INSTRUCTIONS
///////////////////////////////////////////////////////////
// This file contains all of the strings that are used throughout phpScheduleit.
// Please save the translated file as '2 letter language code'.lang.php.  For example, en.lang.php.
// 
// To make phpScheduleIt available in another language, simply translate each
//  of the following strings into the appropriate one for the language.  If there
//  is no direct translation, please provide the closest translation.  Please be sure
//  to make the proper additions the /config/langs.php file (instructions are in the file).
//  Also, please add a help translation for your language using en.help.php as a base.
//
// You will probably keep all sprintf (%s) tags in their current place.  These tags
//  are there as a substitution placeholder.  Please check the output after translating
//  to be sure that the sentences make sense.
//
// + Please use single quotes ' around all $strings.  If you need to use the ' character, please enter it as \'
// + Please use double quotes " around all $email.  If you need to use the " character, please enter it as \"
//
// + For all $dates please use the PHP strftime() syntax
//    http://us2.php.net/manual/en/function.strftime.php
//
// + Non-intuitive parts of this file will be explained with comments.  If you
//    have any questions, please email lqqkout13@users.sourceforge.net
//    or post questions in the Developers forum on SourceForge
//    http://sourceforge.net/forum/forum.php?forum_id=331297
///////////////////////////////////////////////////////////

////////////////////////////////
/* Do not modify this section */
////////////////////////////////
global $strings;			  //
global $email;				  //
global $dates;				  //
global $charset;			  //
global $letters;			  //
global $days_full;			  //
global $days_abbr;			  //
global $days_two;			  //
global $days_letter;		  //
global $months_full;		  //
global $months_abbr;		  //
global $days_letter;		  //
/******************************/

// Charset for this language
// 'iso-8859-1' will work for most languages
$charset = 'iso-8859-2';

/***
  DAY NAMES
  All of these arrays MUST start with Sunday as the first element 
   and go through the seven day week, ending on Saturday
***/
// The full day name
$days_full = array('Nedle', 'Pondl', 'ter', 'Steda', 'tvrtek', 'Ptek', 'Sobota');
// The three letter abbreviation
$days_abbr = array('Ned', 'Pon', 'te', 'St', 'tv', 'Pt', 'Sob');
// The two letter abbreviation
$days_two  = array('Ne', 'Po', 't', 'St', 't', 'P', 'So');
// The one letter abbreviation
$days_letter = array('n', 'P', 'U', 'S', '', 'p', 's');

/***
  MONTH NAMES
  All of these arrays MUST start with January as the first element
   and go through the twelve months of the year, ending on December
***/
// The full month name
$months_full = array('Leden', 'nor', 'Bezen', 'Duben', 'Kvten', 'erven', 'ervenec', 'Srpen', 'Z', 'jen', 'Listopad', 'Prosinec');
// The three letter month name
$months_abbr = array('Led', 'no', 'Be', 'Dub', 'Kv', 'en', 'ec', 'Srp', 'Z', 'j', 'Lis', 'Pro');

// All letters of the alphabet starting with A and ending with Z
$letters = array ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');

/***
  DATE FORMATTING
  All of the date formatting must use the PHP strftime() syntax
  You can include any text/HTML formatting in the translation
***/
// General date formatting used for all date display unless otherwise noted
$dates['general_date'] = '%d/%m/%Y';
// General datetime formatting used for all datetime display unless otherwise noted
// The hour:minute:second will always follow this format
$dates['general_datetime'] = '%d/%m/%Y @';
// Date in the reservation notification popup and email
$dates['res_check'] = '%A %d/%m/%Y';
// Date on the scheduler that appears above the resource links
$dates['schedule_daily'] = '%A,<br/>%d/%m/%Y';
// Date on top-right of each page
$dates['header'] = '%A, %B %d, %Y';
// Jump box format on bottom of the schedule page
// This must only include %m %d %Y in the proper order,
//  other specifiers will be ignored and will corrupt the jump box 
$dates['jumpbox'] = '%d %m %Y';

/***
  STRING TRANSLATIONS
  All of these strings should be translated from the English value (right side of the equals sign) to the new language.
  - Please keep the keys (between the [] brackets) as they are.  The keys will not always be the same as the value.
  - Please keep the sprintf formatting (%s) placeholders where they are unless you are sure it needs to be moved.
  - Please keep the HTML and punctuation as-is unless you know that you want to change it.
***/
$strings['hours'] = 'hodiny';
$strings['minutes'] = 'minuty';
// The common abbreviation to hint that a user should enter the month as 2 digits
$strings['mm'] = 'mm';
// The common abbreviation to hint that a user should enter the day as 2 digits
$strings['dd'] = 'dd';
// The common abbreviation to hint that a user should enter the year as 4 digits
$strings['yyyy'] = 'rrrr';
$strings['am'] = 'am';
$strings['pm'] = 'pm';

$strings['Administrator'] = 'Administrator';
$strings['Welcome Back'] = 'Vtejte zpt, %s';
$strings['Log Out'] = 'Odhlsit se';
$strings['My Control Panel'] = 'Mj dc Panel';
$strings['Help'] = 'Npovda';
$strings['Manage Schedules'] = 'Sprva rozvrh';
$strings['Manage Users'] ='Sprva uivatel';
$strings['Manage Resources'] ='Sprva zdroj';
$strings['Manage User Training'] ='Sprva kolen uivatel';
$strings['Manage Reservations'] ='Sprva rezervac';
$strings['Email Users'] ='Email uivatelm';
$strings['Export Database Data'] = 'Export dat z databze';
$strings['Reset Password'] = 'Reset hesla';
$strings['System Administration'] = 'Administrace systmu';
$strings['Successful update'] = 'spn aktualizace';
$strings['Update failed!'] = 'Aktualizace selhala!';
$strings['Manage Blackout Times'] = 'Sprva as vpadk';
$strings['Forgot Password'] = 'Heslo zapomenuto';
$strings['Manage My Email Contacts'] = 'Sprva mch email kontakt';
$strings['Choose Date'] = 'Vyberte datum';
$strings['Modify My Profile'] = 'Zmnit mj profil';
$strings['Register'] = 'Registrovat';
$strings['Processing Blackout'] = 'Zpracovvn vpadk';
$strings['Processing Reservation'] = 'Zpracovvn rezervac';
$strings['Online Scheduler [Read-only Mode]'] = 'Online Plnova[jen ke ten]';
$strings['Online Scheduler'] = 'Online Plnova';
$strings['phpScheduleIt Statistics'] = 'Statistika rezervac';
$strings['User Info'] = 'Informace o uivateli:';

$strings['Could not determine tool'] = 'Nebylo mon urit nstroj. Vrate se prosm na v dc panel a zkuste znovu pozdji.';
$strings['This is only accessable to the administrator'] = 'Toto je pstupn pouze pro administrtora';
$strings['Back to My Control Panel'] = 'Zpt na Mj dc panel';
$strings['That schedule is not available.'] = 'Tento rozvrh nen pstupn.';
$strings['You did not select any schedules to delete.'] = 'Nevybral jste dn rozvrh k odstrann.';
$strings['You did not select any members to delete.'] = 'Nevybral jste dn uivatele k odstrann.';
$strings['You did not select any resources to delete.'] = 'Nevybral jste dn zdroje k odstrann.';
$strings['Schedule title is required.'] = 'Nzev rozvrhu je vyadovn.';
$strings['Invalid start/end times'] = 'Neplatn asy zatku/konce';
$strings['View days is required'] = 'View days je vyadovn';
$strings['Day offset is required'] = 'Day offset je vyadovn';
$strings['Admin email is required'] = 'Email administrtora je vyadovn';
$strings['Resource name is required.'] = 'Nzev zdroje je vyadovn.';
$strings['Valid schedule must be selected'] = 'Mus bt vybrn platn rozvrh.';
$strings['Minimum reservation length must be less than or equal to maximum reservation length.'] = 'Minimln dlka rezervace mus bt stejn nebo men ne maximln.';
$strings['Your request was processed successfully.'] = 'V poadavek byl spn zpracovn.';
$strings['Go back to system administration'] = 'Jdte zpt na administraci systmu';
$strings['Or wait to be automatically redirected there.'] = 'Nebo pokejte dokud tam nebudete automaticky pesmrovni.';
$strings['There were problems processing your request.'] = 'Pi zpracovn vaeho poadavku se vyskytly problmy.';
$strings['Please go back and correct any errors.'] = 'Prosm vrate se a opravte chyby.';
$strings['Login to view details and place reservations'] = 'Zalogujte se k prohlen podrobnost a zadvn rezervac';
$strings['Memberid is not available.'] = 'Memberid: %s nen dostupn.';

$strings['Schedule Title'] = 'Nzev rozvrhu';
$strings['Start Time'] = 'Poten as';
$strings['End Time'] = 'Koncov as';
$strings['Time Span'] = 'asov rozpt';
$strings['Weekday Start'] = 'Potek tdne';
$strings['Admin Email'] = 'Email administrtora';

$strings['Default'] = 'Vchoz';
$strings['Reset'] = 'Reset';
$strings['Edit'] = 'Upravit';
$strings['Delete'] = 'Odstranit';
$strings['Cancel'] = 'Zruit';
$strings['View'] = 'Zobrazit';
$strings['Modify'] = 'Zmnit';
$strings['Save'] = 'Uloit';
$strings['Back'] = 'Zpt';
$strings['Next'] = 'Dal';
$strings['Close Window'] = 'Zavt okno';
$strings['Search'] = 'Hledat';
$strings['Clear'] = 'Vymazat';

$strings['Days to Show'] = 'Ukzat dny';
$strings['Reservation Offset'] = 'Offset rezervace';
$strings['Hidden'] = 'Skryt';
$strings['Show Summary'] = 'Ukzat souhrn';
$strings['Add Schedule'] = 'Pidat rozvrh';
$strings['Edit Schedule'] = 'Upravit rozvrh';
$strings['No'] = 'Ne';
$strings['Yes'] = 'Ano';
$strings['Name'] = 'Jmno';
$strings['First Name'] = 'Kestn jmno';
$strings['Last Name'] = 'Pjmen';
$strings['Resource Name'] = 'Nzev zdroje';
$strings['Email'] = 'Email';
$strings['Institution'] = 'Instituce';
$strings['Phone'] = 'Telefon';
$strings['Password'] = 'Heslo';
$strings['Permissions'] = 'Oprvnn';
$strings['View information about'] = 'Zobrazit informaci pro: %s %s';
$strings['Send email to'] = 'Poslat email komu: %s %s';
$strings['Reset password for'] = 'Reset hesla pro:  %s %s';
$strings['Edit permissions for'] = 'Upravit oprvnn pro: %s %s';
$strings['Position'] = 'Pozice';
$strings['Password (6 char min)'] = 'Heslo (%s znak minimln)';	// @since 1.1.0
$strings['Re-Enter Password'] = 'Znovu vloit heslo';

$strings['Sort by descending last name'] = 'Setdit sestupn podle pjmen';
$strings['Sort by descending email address'] = 'Setdit sestupn podle emailu';
$strings['Sort by descending institution'] = 'Setdit sestupn podle instituce';
$strings['Sort by ascending last name'] = 'Setdit vzestupn podle pjmen';
$strings['Sort by ascending email address'] = 'Setdit vzestupn podle emailu';
$strings['Sort by ascending institution'] = 'Setdit vzestupn podle instituce';
$strings['Sort by descending resource name'] = 'Setdit sestupn podle nzvu zdroje';
$strings['Sort by descending location'] = 'Setdit sestupn podle umstn';
$strings['Sort by descending schedule title'] = 'Setdit sestupn podle nzvu rozvrhu';
$strings['Sort by ascending resource name'] = 'Setdit vzestupn podle nzvu zdroje';
$strings['Sort by ascending location'] = 'Setdit vzestupn podle umstn';
$strings['Sort by ascending schedule title'] = 'Setdit vzestupn podle nzvu rozvrhu';
$strings['Sort by descending date'] = 'Setdit sestupn podle data';
$strings['Sort by descending user name'] = 'Sestdit sestupn podle jmna uivatele';
$strings['Sort by descending start time'] = 'Setdit sestupn podle potenho asu';
$strings['Sort by descending end time'] = 'Setdit sestupn podle koncovho asu';
$strings['Sort by ascending date'] = 'Setdit vzestupn podle data';
$strings['Sort by ascending user name'] = 'Setdit vzestupn podle jmna uivatele';
$strings['Sort by ascending start time'] = 'Setdit vzestupn podle potenho asu';
$strings['Sort by ascending end time'] = 'Setdit vzestupn podle koncovho asu';
$strings['Sort by descending created time'] = 'Setdit sestupn podle asu vytvoen';
$strings['Sort by ascending created time'] = 'Setdit vzestupn podle asu vytvoen';
$strings['Sort by descending last modified time'] = 'Setdit sestupn podle asu posledn zmny';
$strings['Sort by ascending last modified time'] = 'Setdit vzestupn podle asu posledn zmny';

$strings['Search Users'] = 'Vyhledat uivatele';
$strings['Location'] = 'Umstn';
$strings['Schedule'] = 'Rozvrh';
$strings['Phone'] = 'Telefon';
$strings['Notes'] = 'Poznmky';
$strings['Status'] = 'Stav';
$strings['All Schedules'] = 'Vechny rozvrhy';
$strings['All Resources'] = 'Vechny zdroje';
$strings['All Users'] = 'Vichni uivatel';

$strings['Edit data for'] = 'Upravit data pro: %s';
$strings['Active'] = 'Aktivn';
$strings['Inactive'] = 'Neaktivn';
$strings['Toggle this resource active/inactive'] = 'Pepnte tento zdroj - aktivn/neaktivn';
$strings['Minimum Reservation Time'] = 'Minimln doba rezervace';
$strings['Maximum Reservation Time'] = 'Maximln doba rezervace';
$strings['Auto-assign permission'] = 'Automatick piazen oprvnn';
$strings['Add Resource'] = 'Pidat zdroj';
$strings['Edit Resource'] = 'Upravit zdroj';
$strings['Allowed'] = 'Povolen';
$strings['Notify user'] = 'Uvdomit uivatele';
$strings['User Reservations'] = 'Reservace uivatele';
$strings['Date'] = 'Datum';
$strings['User'] = 'Uivatel';
$strings['Email Users'] = 'Email uivatelm';
$strings['Subject'] = 'Subjekt';
$strings['Message'] = 'Zprva';
$strings['Please select users'] = 'Prosm vyberte uivatele';
$strings['Send Email'] = 'Poslat email';
$strings['problem sending email'] = 'Promite, nepodailo se odeslat v email. Zkuste to prosm pozdji.';
$strings['The email sent successfully.'] = 'Email byl spn odesln.';
$strings['do not refresh page'] = 'Prosm <u>neobnovujte</u> tuto strnku. Email by byl posln znovu.';
$strings['Return to email management'] = 'Zpt ke sprv emailu';
$strings['Please select which tables and fields to export'] = 'Prosm vyberte tabulky a pole k exportu:';
$strings['all fields'] = '- vechna pole -';
$strings['HTML'] = 'HTML';
$strings['Plain text'] = 'Prost text';
$strings['XML'] = 'XML';
$strings['CSV'] = 'CSV';
$strings['Export Data'] = 'Export Dat';
$strings['Reset Password for'] = 'Reset hesla pro: %s';
$strings['Please edit your profile'] = 'Prosm, upravte v profil';
$strings['Please register'] = 'Prosm, registrujte se';
$strings['Keep me logged in'] = 'Udrujte m pihlenho<br/>(vyaduje cookies)';
$strings['Edit Profile'] = 'Upravit profil';
$strings['Register'] = 'Registrace';
$strings['Please Log In'] = 'Prosm, pihlate se';
$strings['Email address'] = 'Emailov adresa';
$strings['Password'] = 'Heslo';
$strings['First time user'] = 'Prvn pipojen?';
$strings['Click here to register'] = 'Kliknte zde pro registraci';
$strings['Register for phpScheduleIt'] = 'Registrace pro rezervace';
$strings['Log In'] = 'Pihlen';
$strings['View Schedule'] = 'Zobrazit rozvrh';
$strings['View a read-only version of the schedule'] = 'Verze rozvrhu pouze ke ten';
$strings['I Forgot My Password'] = 'Zapomnl jsem sv heslo';
$strings['Retreive lost password'] = 'Zskn ztracenho hesla';
$strings['Get online help'] = 'Online npovda';
$strings['Language'] = 'Jazyk';
$strings['(Default)'] = '(Vchoz)';

$strings['My Announcements'] = 'Moje oznmen';
$strings['My Reservations'] = 'Moje rezervace';
$strings['My Permissions'] = 'Moje oprvnn';
$strings['My Quick Links'] = 'Moje rychl odkazy';
$strings['Announcements as of'] = 'Oznmen: %s';
$strings['There are no announcements.'] = 'dn oznmen.';
$strings['Resource'] = 'Zdroj';
$strings['Created'] = 'Vytvoeno';
$strings['Last Modified'] = 'Posledn zmna';
$strings['View this reservation'] = 'Zobraz tuto rezervaci';
$strings['Modify this reservation'] = 'Zm tuto rezervaci';
$strings['Delete this reservation'] = 'Odstranit tuto rezervaci';
$strings['Bookings'] = 'Pehled rezervac';											// @since 1.2.0
$strings['Change My Profile Information/Password'] = 'Zmnit profil';		// @since 1.2.0
$strings['Manage My Email Preferences'] = 'Nastaven emailu';				// @since 1.2.0
$strings['Mass Email Users'] = 'Hromadn email uivatelm';
$strings['Search Scheduled Resource Usage'] = 'Hledat rezervace';		// @since 1.2.0
$strings['Export Database Content'] = 'Export obsahu databze';
$strings['View System Stats'] = 'Zobrazit statistiku systmu';
$strings['Email Administrator'] = 'Email administrtorovi';

$strings['Email me when'] = 'Poli mi email, kdy:';
$strings['I place a reservation'] = 'Zadm rezervaci';
$strings['My reservation is modified'] = 'Moje rezervace je zmnna';
$strings['My reservation is deleted'] = 'Moje rezervace je odstranna';
$strings['I prefer'] = 'Upednostuji:';
$strings['Your email preferences were successfully saved'] = 'Vae emailov nastaven byla spn uloena!';
$strings['Return to My Control Panel'] = 'Zpt na Mj dc panel';

$strings['Please select the starting and ending times'] = 'Prosm zvolte poten a koncov asy:';
$strings['Please change the starting and ending times'] = 'Prosm zmte poten a koncov asy:';
$strings['Reserved time'] = 'Reservovan as:';
$strings['Minimum Reservation Length'] = 'Dlka minimln rezervace:';
$strings['Maximum Reservation Length'] = 'Dlka maximln rezervace:';
$strings['Reserved for'] = 'Rezervovno pro:';
$strings['Will be reserved for'] = 'Bude rezervovno pro:';
$strings['N/A'] = 'N/A';
$strings['Update all recurring records in group'] = 'Aktualizovat vechny opakujc se zznamy ve skupin?';
$strings['Delete?'] = 'Odstranit?';
$strings['Never'] = '-- Nikdy --';
$strings['Days'] = 'Dny';
$strings['Weeks'] = 'Tdny';
$strings['Months (date)'] = 'Msce (datum)';
$strings['Months (day)'] = 'Msce (den)';
$strings['First Days'] = 'Prvn dny';
$strings['Second Days'] = 'Druh dny';
$strings['Third Days'] = 'Tet dny';
$strings['Fourth Days'] = 'tvrt dny';
$strings['Last Days'] = 'Posledn dny';
$strings['Repeat every'] = 'Opakuj kad:';
$strings['Repeat on'] = 'Opakuj kdy:';
$strings['Repeat until date'] = 'Opakuj do data:';
$strings['Choose Date'] = 'Vyberte datum';
$strings['Summary'] = 'Souhrn';

$strings['View schedule'] = 'Zobrazit rozvrh:';
$strings['My Reservations'] = 'Moje rezervace';
$strings['My Past Reservations'] = 'Moje minul rezervace';
$strings['Other Reservations'] = 'Dal rezervace';
$strings['Other Past Reservations'] = 'Dal minul rezervace';
$strings['Blacked Out Time'] = 'Vpadkov as';
$strings['Set blackout times'] = 'Nastavit vpadkov asy pro %s na %s'; 
$strings['Reserve on'] = 'Rezervovat %s na %s';
$strings['Prev Week'] = '&laquo; Pedchoz tden';
$strings['Jump 1 week back'] = 'Skoit 1 tden zpt';
$strings['Prev days'] = '&#8249; Pedch. %d dny';
$strings['Previous days'] = '&#8249; Pedchoz %d dny';
$strings['This Week'] = 'Tento tden';
$strings['Jump to this week'] = 'Skoit do tohoto tdne';
$strings['Next days'] = 'Dalch %d dn &#8250;';
$strings['Next Week'] = 'Dal tden &raquo;';
$strings['Jump To Date'] = 'Skoit na datum';
$strings['View Monthly Calendar'] = 'Zobrazit msn kalend';
$strings['Open up a navigational calendar'] = 'Otevt navigan kalend';

$strings['View stats for schedule'] = 'Zobrazit statistiku pro rozvrh:';
$strings['At A Glance'] = 'Zbn';
$strings['Total Users'] = 'Celkov uivatel:';
$strings['Total Resources'] = 'Celkov zdroje:';
$strings['Total Reservations'] = 'Celkov rezervace:';
$strings['Max Reservation'] = 'Max rezervace:';
$strings['Min Reservation'] = 'Min rezervace:';
$strings['Avg Reservation'] = 'Pmr rezervace:';
$strings['Most Active Resource'] = 'Nejaktivnj zdroj:';
$strings['Most Active User'] = 'Nejaktivnj uivatel:';
$strings['System Stats'] = 'Statistika systmu';
$strings['phpScheduleIt version'] = 'Verze phpScheduleIt:';
$strings['Database backend'] = 'Pouit databzov systm:';
$strings['Database name'] = 'Nzev databze:';
$strings['PHP version'] = 'Verze PHP:';
$strings['Server OS'] = 'OS serveru:';
$strings['Server name'] = 'Nzev serveru:';
$strings['phpScheduleIt root directory'] = 'Koenov adres systmu:';
$strings['Using permissions'] = 'Uvna oprvnn:';
$strings['Using logging'] = 'Uvno logovn:';
$strings['Log file'] = 'Logovac soubor:';
$strings['Admin email address'] = 'Email administrtora:';
$strings['Tech email address'] = 'Email technick podpory:';
$strings['CC email addresses'] = 'CC emailov adresy:';
$strings['Reservation start time'] = 'Poten as rezervace:';
$strings['Reservation end time'] = 'Koncov as rezervace:';
$strings['Days shown at a time'] = 'Poet najednou zobrazovanch dn:';
$strings['Reservations'] = 'Rezervace';
$strings['Return to top'] = 'Zpt na zatek';
$strings['for'] = 'pro';

$strings['Select Search Criteria'] = 'Vyberte vyhledvc kritria';
$strings['Schedules'] = 'Rozvrhy:';
$strings['All Schedules'] = 'Vechny rozvrhy';
$strings['Hold CTRL to select multiple'] = 'Drte CTRL k vcensobnmu vbru';
$strings['Users'] = 'Uivatel:';
$strings['All Users'] = 'Vichni uivatel';
$strings['Resources'] = 'Zdroje';
$strings['All Resources'] = 'Vechny zdroje';
$strings['Starting Date'] = 'Poten datum:';
$strings['Ending Date'] = 'Koncov datum:';
$strings['Starting Time'] = 'Poten as:';
$strings['Ending Time'] = 'Koncov as:';
$strings['Output Type'] = 'Typ vstupu:';
$strings['Manage'] = 'Spravovat';
$strings['Total Time'] = 'Cekov as';
$strings['Total hours'] = 'Celov hodin:';
$strings['% of total resource time'] = '% celkovho asu zdroje';
$strings['View these results as'] = 'Zobrazit tyto vsledky jako:';
$strings['Edit this reservation'] = 'Upravit tuto rezervaci';
$strings['Search Results'] = 'Prohledat vsledky';
$strings['Search Resource Usage'] = 'Vyhledat vyuit zdroje';
$strings['Search Results found'] = 'Vsledky vyhledvn: %d rezervac nalezeno';
$strings['Try a different search'] = 'Zkuste jin vyhledvn';
$strings['Search Run On'] = 'Spustit vyhledvn na:';
$strings['Member ID'] = 'ID uivatele';
$strings['Previous User'] = '&laquo; Pedchoz uivatel';
$strings['Next User'] = 'Dal uivatel &raquo;';

$strings['No results'] = 'dn vsledky';
$strings['That record could not be found.'] = 'Tento zznam nebyl nalezen.';
$strings['This blackout is not recurring.'] = 'Tento vpadek nen opakovan.';
$strings['This reservation is not recurring.'] = 'Tato rezervace nen opakovan.';
$strings['There are no records in the table.'] = 'V tabulce %s nejsou dn zznamy.';
$strings['You do not have any reservations scheduled.'] = 'Nemte naplnovny dn rezervace.';
$strings['You do not have permission to use any resources.'] = 'Nemte oprvnn pouvat jakkoli zdroj.';
$strings['No resources in the database.'] = 'V databzi nejsou dn zdroje.';
$strings['There was an error executing your query'] = 'Pi zpracovvn vaeho dotazu dolo k chyb:';

$strings['That cookie seems to be invalid'] = 'Tento cookie je neplatn';
$strings['We could not find that logon in our database.'] = 'Toto pihlen nebylo v na databzi nalezeno.';	// @since 1.1.0
$strings['That password did not match the one in our database.'] = 'Toto heslo se neshodovalo s tm z na databze.';
$strings['You can try'] = '<br />Mete zkusit:<br />Registrovat email adresu.<br />Nebo:<br />Zkusit pihlen znovu.';
$strings['A new user has been added'] = 'Nov uivatel byl pidn';
$strings['You have successfully registered'] = 'Byl jste spn zaregistrovn!';
$strings['Continue'] = 'Pokraovat...';
$strings['Your profile has been successfully updated!'] = 'V profil byl spn aktualizovn!';
$strings['Please return to My Control Panel'] = 'Prosm vrtit na Mj dc panel';
$strings['Valid email address is required.'] = '- je vyadovna platn emailov adresa.';
$strings['First name is required.'] = '- Kestn jmno je vyadovno.';
$strings['Last name is required.'] = '- Pjmen je vyadovno.';
$strings['Phone number is required.'] = '- Telefonn slo je vyadovno.';
$strings['That email is taken already.'] = '- Tento email je ji obsazen.<br />Prosm zkuste znovu s rozdlnou emailovou adresou.';
$strings['Min 6 character password is required.'] = '- Je vyadovno heslo s nejmn %s znaky.';
$strings['Passwords do not match.'] = '- Hesla se neshoduj.';

$strings['Per page'] = 'Na strnku:';
$strings['Page'] = 'Strnka:';

$strings['Your reservation was successfully created'] = 'Vae rezervace byla spn vytvoena';
$strings['Your reservation was successfully modified'] = 'Vae rezervace byla spn zmnna';
$strings['Your reservation was successfully deleted'] = 'Vae rezervace byla spn odstranna';
$strings['Your blackout was successfully created'] = 'V vpadek byl spn vytvoen';
$strings['Your blackout was successfully modified'] = 'V vpadek byl spn zmnn';
$strings['Your blackout was successfully deleted'] = 'V vpadek byl spn odstrann';
$strings['for the follwing dates'] = 'pro nsledujc data:';
$strings['Start time must be less than end time'] = 'Poten as mus bt men ne koncov as.';
$strings['Current start time is'] = 'Aktuln poten as je:';
$strings['Current end time is'] = 'Aktuln koncov as je:';
$strings['Reservation length does not fall within this resource\'s allowed length.'] = 'Dlka rezervace je nen v intervalu povolen dlky pro tento zdroj.';
$strings['Your reservation is'] = 'Vae rezervace je:';
$strings['Minimum reservation length'] = 'Minimln dlka rezervace:';
$strings['Maximum reservation length'] = 'Maximln dlka rezervace:';
$strings['You do not have permission to use this resource.'] = 'Nemte oprvnn k pouit tohoto zdroje.';
$strings['reserved or unavailable'] = '%s a %s je rezervovn nebo nepstupn.';	// @since 1.1.0
$strings['Reservation created for'] = 'Rezervace vytvoena pro %s';
$strings['Reservation modified for'] = 'Rezervace zmnna pro %s';
$strings['Reservation deleted for'] = 'Rezervace odstranna pro %s';
$strings['created'] = 'vytvoeno';
$strings['modified'] = 'zmnno';
$strings['deleted'] = 'odstranno';
$strings['Reservation #'] = 'Rezervace #';
$strings['Contact'] = 'Kontakt';
$strings['Reservation created'] = 'Rezervace vytvoena';
$strings['Reservation modified'] = 'Rezervace zmnna';
$strings['Reservation deleted'] = 'Rezervace odstranna';

$strings['Reservations by month'] = 'Rezervace po mscch';
$strings['Reservations by day of the week'] = 'Rezervace po dnech v tdnu';
$strings['Reservations per month'] = 'Rezervace po dnech v msci';
$strings['Reservations per user'] = 'Rezervace na uivatele';
$strings['Reservations per resource'] = 'Rezervace na zdroj';
$strings['Reservations per start time'] = 'Rezervace podle potenho asu';
$strings['Reservations per end time'] = 'Rezervace podle koncovho asu';
$strings['[All Reservations]'] = '[Vechny rezervace]';

$strings['Permissions Updated'] = 'Oprvnn aktualizovna';
$strings['Your permissions have been updated'] = 'Vae %s oprvnn byla aktualizovna';
$strings['You now do not have permission to use any resources.'] = 'Nyn nemte oprvnn k pouit dnho zdroje.';
$strings['You now have permission to use the following resources'] = 'Nyn mte oprvnn k pouit nsledujc zdroje:';
$strings['Please contact with any questions.'] = 'Prosm kontaktujte %s s jakmkoli dotazem.';
$strings['Password Reset'] = 'Reset hesla';

$strings['This will change your password to a new, randomly generated one.'] = 'Toto zmn vae heslo na nov, nhodn vygenerovan.';
$strings['your new password will be set'] = 'Po vloen vaeho emailu a kliknut na "Zmnit heslo", nastav vm systm nastav nov heslo a zale ho emailem.';
$strings['Change Password'] = 'Zmnit heslo';
$strings['Sorry, we could not find that user in the database.'] = 'Promite, nemohli jsme najt tohoto uivatele v databzi.';
$strings['Your New Password'] = 'Vae nov %s heslo';
$strings['Your new passsword has been emailed to you.'] = 'spch!<br />'
    			. 'Vae nov heslo vm bylo zaslno emailem.<br />'
    			. 'Prosm podvejte se do va emailov schrnky na nov heslo, pak se <a href="index.php">pihlate</a>'
    			. ' s tmto novm heslem a urychlen ho zmte kliknutm na odkaz &quot;Zmnit mj profil/heslo&quot;'
    			. ' v Mm dcm panelu.';

$strings['You are not logged in!'] = 'Nejste pihlen!';

$strings['Setup'] = 'Setup';
$strings['Please log into your database'] = 'Prosm pihlate se do va databze';
$strings['Enter database root username'] = 'Vlote uivatelsk jmno adminitrtora databze:';
$strings['Enter database root password'] = 'Vlote heslo administrtora databze:';
$strings['Login to database'] = 'Pihlen do databze';
$strings['Root user is not required. Any database user who has permission to create tables is acceptable.'] = 'Administrtorsk prva <b>nejsou vyadovna</b>. Kterkoli uivatel databze s prvem vytvet tabulky postauje.';
$strings['This will set up all the necessary databases and tables for phpScheduleIt.'] = 'Toto nastav nezbytn databze a tabulky pro phpScheduleIt.';
$strings['It also populates any required tables.'] = 'Vypn rovn potebn tabulky.';
$strings['Warning: THIS WILL ERASE ALL DATA IN PREVIOUS phpScheduleIt DATABASES!'] = 'Varovn: TOTO ODSTRAN VECHNA DATA V PEDCHOZCH DATABZCH phpScheduleIt!';
$strings['Not a valid database type in the config.php file.'] = 'Neplatn typ databze v souboru config.php.';
$strings['Database user password is not set in the config.php file.'] = 'Heslo pro uivatele databze nen nastaveno v souboru config.php.';
$strings['Database name not set in the config.php file.'] = 'Nzev databze nen nastaven v souboru config.php.';
$strings['Successfully connected as'] = 'spn pipojen jako';
$strings['Create tables'] = 'Vytvoit tabulky &gt;';
$strings['There were errors during the install.'] = 'Bhem instalace se vyskytly chyby. Je mon, e phpScheduleIt bude it tak fungovat, pokud chyby nebyly zvan.<br/><br/>'
	. 'Prostm vzneste jakkoli dotazy v diskuznch frech na <a href="http://sourceforge.net/forum/?group_id=95547">SourceForge</a>.';
$strings['You have successfully finished setting up phpScheduleIt and are ready to begin using it.'] = 'spn jste dokonili nastaven phpScheduleIt a mete ho zat pouvat.';
$strings['Thank you for using phpScheduleIt'] = 'Prosm zajistte PLN ODSTRANN ADRESE \'install\' .'
	. ' To je velmi dleit, protoe obsahuje hesla do databze a dal citliv informace.'
	. ' Pokud to neprovedete, nechte zcela oteven dvee komukoli k proniknut do va databze!'
	. '<br /><br />'
	. 'Dkujeme vm, e pouvte phpScheduleIt!';
$strings['There is no way to undo this action'] = 'Tuto akci nen dnm zpsobem mon vrtit zpt!';
$strings['Click to proceed'] = 'Kliknte pro pokraovn';
$strings['Please delete this file.'] = 'Prosm odstrate tento soubor.';
$strings['Successful update'] = 'Aktualizace probhla naprosto v podku';
$strings['Patch completed successfully'] = 'Zplata byla spn aplikovna';

// @since 1.0.0 RC1
$strings['If no value is specified, the default password set in the config file will be used.'] = 'Pokud nen uvedena dn hodnota, bude pouito heslo uveden v konfiguranm souboru.';
$strings['Notify user that password has been changed?'] = 'Uvdomit uivatele, e bylo heslo zmnno?';

// @since 1.1.0
$strings['This system requires that you have an email address.'] = 'Tento systm vyaduje, abyste mli emailovou adresu.';
$strings['Invalid User Name/Password.'] = 'Neplatn uivatelsk jmno/heslo.';
$strings['Pending User Reservations'] = 'Nevyzen uivatelsk rezervace';
$strings['Approve'] = 'Schvlit';
$strings['Approve this reservation'] = 'Schvlit tuto rezervaci';
$strings['Approve Reservations'] ='Schvlit rezervace';

$strings['Announcement'] = 'Oznmen';
$strings['Number'] = 'slo';
$strings['Add Announcement'] = 'Pidat oznmen';
$strings['Edit Announcement'] = 'Upravit oznmen';
$strings['All Announcements'] = 'Vechna oznmen';
$strings['Delete Announcements'] = 'Odstranit oznmen';
$strings['Use start date/time?'] = 'Pout poten datum/as?';
$strings['Use end date/time?'] = 'Pout koncov datum/as?';
$strings['Announcement text is required.'] = 'Text oznmen je vyadovn.';
$strings['Announcement number is required.'] = 'slo oznmen je vyadovno.';

$strings['Pending Approval'] = 'Nevyzen schvlen';
$strings['My reservation is approved'] = 'Moje rezervace je schvlena';
$strings['This reservation must be approved by the administrator.'] = 'Tato rezervace mus bt schvlena administrtorem.';
$strings['Approval Required'] = 'Schvlen je vyadovno';
$strings['No reservations requiring approval'] = 'dn rezervace vyadujc schvlen';
$strings['Your reservation was successfully approved'] = 'Vae rezervace byla spn schvlena';
$strings['Reservation approved for'] = 'Rezervace schvlena pro %s';
$strings['approved'] = 'schvleno';
$strings['Reservation approved'] = 'Rezervace schvlena';

$strings['Valid username is required'] = 'Je vyadovno platn uivatelsk jmno';
$strings['That logon name is taken already.'] = 'Toto pihlaovac jmno je ji pouvno.';
$strings['this will be your login'] = '(toto bude vae pihlaovac jmno)';
$strings['Logon name'] = 'Pihlaovac jmno';
$strings['Your logon name is'] = 'Vae pihlaovac jmno je %s';

$strings['Start'] = 'Potek';
$strings['End'] = 'Konec';
$strings['Start date must be less than or equal to end date'] = 'Poten datum mus bt men ne nebo rovno koncovmu datu';
$strings['That starting date has already passed'] = 'Poten datum ji ubhlo';
$strings['Basic'] = 'Zkladn';
$strings['Participants'] = 'astnci';
$strings['Close'] = 'Zavt';
$strings['Start Date'] = 'Poten datum';
$strings['End Date'] = 'Koncov datum';
$strings['Minimum'] = 'Od';
$strings['Maximum'] = 'Do';
$strings['Allow Multiple Day Reservations'] = 'Povolit rezervaci vce dn';
$strings['Invited Users'] = 'Pozvan uivatel';
$strings['Invite Users'] = 'Pozvat uivatele';
$strings['Remove Participants'] = 'Odstranit astnky';
$strings['Reservation Invitation'] = 'Pozvn rezervace';
$strings['Manage Invites'] = 'Sprva pozvnek';
$strings['No invite was selected'] = 'Nebyly vybrny dn pozvnky';
$strings['reservation accepted'] = '%s Vae pozvn na %s pijato';
$strings['reservation declined'] = '%s Vao pozvn na %s zamtnuto';
$strings['Login to manage all of your invitiations'] = 'Pihlate se ke sprv vech Vaich pozvn';
$strings['Reservation Participation Change'] = 'Zmna asti na rezervaci';
$strings['My Invitations'] = 'Moje pozvn';
$strings['Accept'] = 'Pijmout';
$strings['Decline'] = 'Zamtnout';
$strings['Accept or decline this reservation'] = 'Pijmout nebo zamtnout tuto rezervaci';
$strings['My Reservation Participation'] = 'Moje ast na rezervaci';
$strings['End Participation'] = 'Konec asti';
$strings['Owner'] = 'Vlastnk';
$strings['Particpating Users'] = 'astnc se uivatel';
$strings['No advanced options available'] = 'dn pokroil volby nejsou pstupn';
$strings['Confirm reservation participation'] = 'Potvrte ast na rezervaci';
$strings['Confirm'] = 'Potvrdit';
$strings['Do for all reservations in the group?'] = 'Provst pro vechny rezervace ve skupin?';

$strings['My Calendar'] = 'Mj kalend';
$strings['View My Calendar'] = 'Zobrazi Mj kalend';
$strings['Participant'] = 'astnk';
$strings['Recurring'] = 'Opakujc se';
$strings['Multiple Day'] = 'Vce dn';
$strings['[today]'] = '[dnes]';
$strings['Day View'] = 'Zobrazen dne';
$strings['Week View'] = 'Zobrazen tdne';
$strings['Month View'] = 'Zobrazen msce';
$strings['Resource Calendar'] = 'Kalend zdroj';
$strings['View Resource Calendar'] = 'Kalend rozvrh';	// @since 1.2.0
$strings['Signup View'] = 'Zobrazen registrace';

$strings['Select User'] = 'Vybrat uivatele';
$strings['Change'] = 'Zmnit';

$strings['Update'] = 'Aktualizovat';
$strings['phpScheduleIt Update is only available for versions 1.0.0 or later'] = 'Aktualizace phpScheduleIt je dostupn pouze pro verze 1.0.0 a pozdj';
$strings['phpScheduleIt is already up to date'] = 'phpScheduleIt je ji aktualizovn';
$strings['Migrating reservations'] = 'Migrujc rezervace';

$strings['Admin'] = 'Admin';
$strings['Manage Announcements'] = 'Sprva oznmen';
$strings['There are no announcements'] = 'Nejsou dn oznmen';
// end since 1.1.0

// @since 1.2.0
$strings['Maximum Participant Capacity'] = 'Maximln kapacita astnk';
$strings['Leave blank for unlimited'] = 'Nechte przdn pro bez omezen';
$strings['Maximum of participants'] = 'Tento zdroj m maximln kapacitu %s uastnk';
$strings['That reservation is at full capacity.'] = 'Tato rezervace je zcela zaplnna.';
$strings['Allow registered users to join?'] = 'Umonit pipojit se registrovnm uivatelm?';
$strings['Allow non-registered users to join?'] = 'Umonit pipojit se neregistrovanm uivatelm?';
$strings['Join'] = 'Pipojit se';
$strings['My Participation Options'] = 'M astnck nastaven';
$strings['Join Reservation'] = 'Pipojit se k rezervacm';
$strings['Join All Recurring'] = 'Pipojit se ke vem opakovanm';
$strings['You are not participating on the following reservation dates because they are at full capacity.'] = 'Neastnte se nsledujcch rezervac, protoe maj zaplnnou kapacitu.';
$strings['You are already invited to this reservation. Please follow participation instructions previously sent to your email.'] = 'K tto rezervaci jste ji byl pozvn. Prosm drte se instrukc pro uastnky zaslan emailem.';
$strings['Additional Tools'] = 'Dal nstroje';
$strings['Create User'] = 'Vytvoit uivatele';
$strings['Check Availability'] = 'Zjisti dostupnost';
$strings['Manage Additional Resources'] = 'Nasatevn dodatench zdroj';
$strings['All Additional Resources'] = 'Vechny dodaten zdroje';
$strings['Number Available'] = 'Poet dostupnch';
$strings['Unlimited'] = 'Neomezen';
$strings['Add Additional Resource'] = 'Pidat dodaten zdroj';
$strings['Edit Additional Resource'] = 'Upravit dodaten zdroj';
$strings['Checking'] = 'Checking';
$strings['You did not select anything to delete.'] = 'Nebylo nic vybrno ke smazn';
$strings['Added Resources'] = 'Pidan zdroje';
$strings['Additional resource is reserved'] = 'Dodaten zdroj %s je dostupn pouze v potu %s';
$strings['All Groups'] = 'Vechny skupiny';
$strings['Group Name'] = 'Nzev skupiny';
$strings['Delete Groups'] = 'Smazat skupiny';
$strings['Manage Groups'] = 'Sprva skupin';
$strings['None'] = 'dn';
$strings['Group name is required.'] = 'Nzev skupiny je vyadovn.';
$strings['Groups'] = 'Skupiny';
$strings['Current Groups'] = 'Aktuln skupiny';
$strings['Group Administration'] = 'Sprva skupin';
$strings['Reminder Subject'] = 'Pipomnka rezervace - %s, %s %s';
$strings['Reminder'] = 'Pipomnka';
$strings['before reservation'] = 'ped rezervac';
$strings['My Participation'] = 'Moje ast';
$strings['My Past Participation'] = 'Moje minul ast';
$strings['Timezone'] = 'asov zna';
$strings['Export'] = 'Export';
$strings['Select reservations to export'] = 'Vyberte rezervace pro export';
$strings['Export Format'] = 'Formt pro export';
$strings['This resource cannot be reserved less than x hours in advance'] = 'Tento zdroj neme bt rezervovn mn ne %s hodin pedem';
$strings['This resource cannot be reserved more than x hours in advance'] = 'Tento zdroj neme bt rezervovn vce ne %s hodin pedem';
$strings['Minimum Booking Notice'] = 'Oznmen o zatku rezervace';
$strings['Maximum Booking Notice'] = 'Oznmen o konci rezervace';
$strings['hours prior to the start time'] = 'hodin ped zatkem';
$strings['hours from the current time'] = 'hodin od aktulnho asu';
$strings['Contains'] = 'Obsahuje';
$strings['Begins with'] = 'Zan na';
$strings['Minimum booking notice is required.'] = 'Oznmen o potku rezervaci je vyadovno.';
$strings['Maximum booking notice is required.'] = 'Oznmen o konci rezervace je vyadovno.';
$strings['Accessory Name'] = 'Nzev doplku';
$strings['Accessories'] = 'Doplky';
$strings['All Accessories'] = 'Vechny doplky';
$strings['Added Accessories'] = 'Pidan doplky';
// end since 1.2.0

/***
  EMAIL MESSAGES
  Please translate these email messages into your language.  You should keep the sprintf (%s) placeholders
   in their current position unless you know you need to move them.
  All email messages should be surrounded by double quotes "
  Each email message will be described below.
***/
// @since 1.1.0
// Email message that a user gets after they register
$email['register'] = "%s, %s \r\n"
				. "Byl jste spn registrovn s nsledujcmi daji:\r\n"
				. "Pihlaovac jmno: %s\r\n"
				. "Jmno: %s %s \r\n"
				. "Telefon: %s \r\n"
				. "Instituce: %s \r\n"
				. "Pozice: %s \r\n\r\n"
				. "Prosm pihlate se k Plnovai na tto adrese:\r\n"
				. "%s \r\n\r\n"
				. "Upravit svj profil a najt odkazy na online Plnova mete v sekci Mj dc panel.\r\n\r\n"
				. "Prosm polete jakkoli dotazy ohledn zdroj nebo rezervac na adresu %s";

// Email message the admin gets after a new user registers
$email['register_admin'] = "Administrtor,\r\n\r\n"
					. "Byl registrovn nov uivatel s nsledujcmi daji:\r\n"
					. "Email: %s \r\n"
					. "Jmno: %s %s \r\n"
					. "Telefon: %s \r\n"
					. "Instituce: %s \r\n"
					. "Pozice: %s \r\n\r\n";

// First part of the email that a user gets after they create/modify/delete a reservation
// 'reservation_activity_1' through 'reservation_activity_6' are all part of one email message
//  that needs to be assembled depending on different options.  Please translate all of them.
// @since 1.1.0
$email['reservation_activity_1'] = "%s,\r\n<br />"
			. "Mte spnou %s rezervaci #%s.\r\n\r\n<br/><br/>"
			. "Prosm pouvejte toto slo rezervace pi kontaktu administrtora s jakoukoli otzkou.\r\n\r\n<br/><br/>"
			. "Rezervace mezi %s %s a %s %s pro %s"
			. " v mst %s byla %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_2'] = "Tato rezervace se opakuje v nsledujc dny:\r\n<br/>";
$email['reservation_activity_3'] = "Vechny opakujc se rezervace v tto skupin byly tak %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_4'] = "Pro tuto rezervaci byl poskytnut nsledujc souhrn :\r\n<br/>%s\r\n\r\n<br/><br/>";
$email['reservation_activity_5'] = "Pokud se jedn o chybu, prosm kontaktujte administrtora na: %s"
			. " nebo volejte  %s.\r\n\r\n<br/><br/>"
			. "Informace o va rezervaci mete prohlet nebo mnit kdykoli po"
			. " pihlen do %s na adrese:\r\n<br/>"
			. "<a href=\"%s\" target=\"_blank\">%s</a>.\r\n\r\n<br/><br/>";
$email['reservation_activity_6'] = "Prosm smujte vechny technick dotazy na <a href=\"mailto:%s\">%s</a>.\r\n\r\n<br/><br/>";
// @since 1.1.0
$email['reservation_activity_7'] = "%s,\r\n<br />"
			. "Rezervace #%s byla schvlena.\r\n\r\n<br/><br/>"
			. "Prosm pouvejte toto slo rezervace pi kontaktu administrtora s jakmkoli dotazem.\r\n\r\n<br/><br/>"
			. "Rezervace mezi %s %s a %s %s pro %s"
			. " umstn v %s byla %s.\r\n\r\n<br/><br/>";

// Email that the user gets when the administrator changes their password
$email['password_reset'] = "Vae %s heslo bylo resetovno administrtorem.\r\n\r\n"
			. "Vae doasn heslo je:\r\n\r\n %s\r\n\r\n"
			. "Prosm pouijte toto doasn heslo (k zajitn sprvnosti pouijte funkce pravy | Koprovat a Vloit) pro pihlen do %s na %s"
			. " a okamit ho zmte pomoc odkazu 'Zmnit Mj profil/Heslo' z tabulky Moje rychl odkazy.\r\n\r\n"
			. "Prosm, kontaktujte %s s jakmkoli dotazem.";

// Email that the user gets when they change their lost password using the 'Password Reset' form
$email['new_password'] = "%s,\r\n"
            . "Vae nov heslo pro v %s et je:\r\n\r\n"
            . "%s\r\n\r\n"
            . "Prosm, pihlate se na %s "
            . "s tmto heslem "
            . "(k zajitn sprvnosti pouijte funkce pravy | Koprovat a Vloit) "
            . "a okamit zmte vae heslo kliknutm na "
            . "odkaz Zmnit Mj profil/Heslo "
            . "v sekci Mj dc panel.\r\n\r\n"
            . "Prosm, smujte jakkoli dotazy na %s.";

// @since 1.1.0
// Email that is sent to invite users to a reservation
$email['reservation_invite'] = "%s vs pozval k asti na nsledujc rezervaci:\r\n\r\n"
		. "Zdroj: %s\r\n"
		. "Poten datum: %s\r\n"
		. "Poten as: %s\r\n"
		. "Koncov datum: %s\r\n"
		. "Koncov as: %s\r\n"
		. "Souhrn: %s\r\n"
		. "Opakovan data (pokud jsou ptomna): %s\r\n\r\n"
		. "Pro pijet tto pozvnky kliknte na tento odkaz (Koprujte a Vlote, pokud nen zvraznn) %s\r\n"
		. "Pro odmtnut tto pozvnky kliknte na tento link (Koprujte a Vlote, pokud nen zvraznn) %s\r\n"
		. "Pro pijet vybranch dat nebo sprvu pozvnek pozdji se pihlato do %s na %s";

// @since 1.1.0
// Email that is sent when a user is removed from a reservation
$email['reservation_removal'] = "Byl jste odstrann z nsledujcch rezervace:\r\n\r\n"
		. "Zdroj: %s\r\n"
		. "Poten datum: %s\r\n"
		. "Poten as: %s\r\n"
		. "Koncov datum: %s\r\n"
		. "Koncov as: %s\r\n"
		. "Souhrn: %s\r\n"
		. "Opakovan data (pokud jsou ptomna): %s\r\n\r\n";
		
// @since 1.2.0
// Email body that is sent for reminders
$email['Reminder Body'] = "Vae rezervace na %s od %s %s do %s %s se bl.";
?>