<?php
/**
* Finnish (fi) translation file.
*  
* @author Nick Korbel <lqqkout13@users.sourceforge.net>
* @translator Veli-Matti Koukeri <vmkoukeri@saunalahti.fi> & Jari Salmela <jasa.1977@gmail.com>
* @version 06-06-07
* @package Languages
*
* Copyright (C) 2003 - 2007 phpScheduleIt
* License: GPL, see LICENSE
*/
///////////////////////////////////////////////////////////
// INSTRUCTIONS
///////////////////////////////////////////////////////////
// This file contains all of the strings that are used throughout phpScheduleit.
// Please save the translated file as '2 letter language code'.lang.php.  For example, en.lang.php.
// 
// To make phpScheduleIt available in another language, simply translate each
//  of the following strings into the appropriate one for the language.  If there
//  is no direct translation, please provide the closest translation.  Please be sure
//  to make the proper additions the /config/langs.php file (instructions are in the file).
//  Also, please add a help translation for your language using en.help.php as a base.
//
// You will probably keep all sprintf (%s) tags in their current place.  These tags
//  are there as a substitution placeholder.  Please check the output after translating
//  to be sure that the sentences make sense.
//
// + Please use single quotes ' around all $strings.  If you need to use the ' character, please enter it as \'
// + Please use double quotes " around all $email.  If you need to use the " character, please enter it as \"
//
// + For all $dates please use the PHP strftime() syntax
//    http://us2.php.net/manual/en/function.strftime.php
//
// + Non-intuitive parts of this file will be explained with comments.  If you
//    have any questions, please email lqqkout13@users.sourceforge.net
//    or post questions in the Developers forum on SourceForge
//    http://sourceforge.net/forum/forum.php?forum_id=331297
///////////////////////////////////////////////////////////

////////////////////////////////
/* Do not modify this section */
////////////////////////////////
global $strings;			  //
global $email;				  //
global $dates;				  //
global $charset;			  //
global $letters;			  //
global $days_full;			  //
global $days_abbr;			  //
global $days_two;			  //
global $days_letter;		  //
global $months_full;		  //
global $months_abbr;		  //
global $days_letter;		  //
/******************************/

// Charset for this language
// 'iso-8859-1' will work for most languages
$charset = 'iso-8859-1';

/***
  DAY NAMES
  All of these arrays MUST start with Sunday as the first element 
   and go through the seven day week, ending on Saturday
***/
// The full day name
$days_full = array('sunnuntai', 'maanantai', 'tiistai', 'keskiviikko', 'torstai', 'perjantai', 'lauantai');
// The three letter abbreviation
$days_abbr = array('sun', 'maa', 'tii', 'kes', 'tor', 'per', 'lau');
// The two letter abbreviation
$days_two  = array('su', 'ma', 'ti', 'ke', 'to', 'pe', 'la');
// The one letter abbreviation
$days_letter = array('S', 'M', 'T', 'K', 'T', 'P', 'L');

/***
  MONTH NAMES
  All of these arrays MUST start with January as the first element
   and go through the twelve months of the year, ending on December
***/
// The full month name
$months_full = array('tammikuu', 'helmikuu', 'maaliskuu', 'huhtikuu', 'toukokuu', 'keskuuta', 'heinkuu', 'elokuu', 'syyskuu', 'lokakuu', 'marraskuu', 'joulukuu');
// The three letter month name
$months_abbr = array('tammi', 'helmi', 'maalis', 'huhti', 'touko', 'kes', 'hein', 'elo', 'syys', 'loka', 'marras', 'joulu');

// All letters of the alphabet starting with A and ending with Z
$letters = array ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');

/***
  DATE FORMATTING
  All of the date formatting must use the PHP strftime() syntax
  You can include any text/HTML formatting in the translation
***/
// General date formatting used for all date display unless otherwise noted
$dates['general_date'] = '%d.%m.%Y';
// General datetime formatting used for all datetime display unless otherwise noted
// The hour:minute:second will always follow this format
$dates['general_datetime'] = '%d.%m.%Y @';
// Date in the reservation notification popup and email
$dates['res_check'] = '%A %d.%m.%Y';
// Date on the scheduler that appears above the resource links
$dates['schedule_daily'] = '%A,<br/>%d.%m.%Y';
// Date on top-right of each page
$dates['header'] = '%A, %B %d, %Y';
// Jump box format on bottom of the schedule page
// This must only include %m %d %Y in the proper order,
//  other specifiers will be ignored and will corrupt the jump box 
$dates['jumpbox'] = '%m %d %Y';

/***
  STRING TRANSLATIONS
  All of these strings should be translated from the English value (right side of the equals sign) to the new language.
  - Please keep the keys (between the [] brackets) as they are.  The keys will not always be the same as the value.
  - Please keep the sprintf formatting (%s) placeholders where they are unless you are sure it needs to be moved.
  - Please keep the HTML and punctuation as-is unless you know that you want to change it.
***/
$strings['hours'] = 'tuntia';
$strings['minutes'] = 'minuuttia';
// The common abbreviation to hint that a user should enter the month as 2 digits
$strings['mm'] = 'mm';
// The common abbreviation to hint that a user should enter the day as 2 digits
$strings['dd'] = 'pp';
// The common abbreviation to hint that a user should enter the year as 4 digits
$strings['yyyy'] = 'vvvv';
$strings['am'] = 'am';
$strings['pm'] = 'pm';

$strings['Administrator'] = 'Yllpitj';
$strings['Welcome Back'] = 'Tervetuloa, %s';
$strings['Log Out'] = 'Kirjaudu Ulos';
$strings['My Control Panel'] = 'Ohjauspaneeli';
$strings['Help'] = 'Ohjeet';
$strings['Manage Schedules'] = 'Aikataulut';
$strings['Manage Users'] = 'Kyttjt';
$strings['Manage Resources'] = 'Resurssit';
$strings['Manage User Training'] = 'Kyttjkoulutukset';
$strings['Manage Reservations'] = 'Varaukset';
$strings['Email Users'] = 'Lhet shkpostia';
$strings['Export Database Data'] = 'Vie tietokannan tiedot';
$strings['Reset Password'] = 'Palauta salasana';
$strings['System Administration'] = 'Jrjestelmnhallinta';
$strings['Successful update'] = 'Pivitys onnistui!';
$strings['Update failed!'] = 'Pivitys eponnistui!';
$strings['Manage Blackout Times'] = 'Kyttkatkot';
$strings['Forgot Password'] = 'Unohtunut salasana';
$strings['Manage My Email Contacts'] = 'Osoitekirja';
$strings['Choose Date'] = 'Valitse pivmr';
$strings['Modify My Profile'] = 'Muuta profiilia';
$strings['Register'] = 'Rekisteridy';
$strings['Processing Blackout'] = 'Ksitelln kytstpoistoa';
$strings['Processing Reservation'] = 'Ksitelln varausta';
$strings['Online Scheduler [Read-only Mode]'] = 'Online-aikataulu [Vain lukuoikeus]';
$strings['Online Scheduler'] = 'Online-aikataulu';
$strings['phpScheduleIt Statistics'] = 'phpScheduleIt -tilastot';
$strings['User Info'] = 'Kyttjn tiedot:';

$strings['Could not determine tool'] = 'Toimintoa ei voitu mritt. Palaa ohjauspaneeliin, ja yrit uudelleen.';
$strings['This is only accessable to the administrator'] = 'Vain yllpitjn kytss.';
$strings['Back to My Control Panel'] = 'Takaisin ohjauspaneeliin.';
$strings['That schedule is not available.'] = 'Aikataulu ei ole saatavissa.';
$strings['You did not select any schedules to delete.'] = 'Et valinnut poistettavia aikatauluja.';
$strings['You did not select any members to delete.'] = 'Et valinnut poistettavia osallistujia.';
$strings['You did not select any resources to delete.'] = 'Et valinnut poistettavia resursseja.';
$strings['Schedule title is required.'] = 'Aikataulun otsikko on pakollinen tieto.';
$strings['Invalid start/end times'] = 'Epkelpo aloitus-/lopetus -ajankohta';
$strings['View days is required'] = 'Nytettv ajanjakso on pakollinen tieto.';
$strings['Day offset is required'] = 'Pivsiirtym on pakollinen tieto.';
$strings['Admin email is required'] = 'Yllpitjn shkpostiosoite on pakollinen tieto.';
$strings['Resource name is required.'] = 'Resurssin nimi on pakollinen tieto.';
$strings['Valid schedule must be selected'] = 'Valitse kelvollinen aikataulu.';
$strings['Minimum reservation length must be less than or equal to maximum reservation length.'] = 'Vhimmisvarausajan on oltava vhintn yhtsuuri, kuin enimmisvarausaika.';
$strings['Your request was processed successfully.'] = 'Syttmsi tieto ksiteltiin onnistuneesti.';
$strings['Go back to system administration'] = 'Palaa jrjestelmnhallintaan';
$strings['Or wait to be automatically redirected there.'] = 'tai odota uudelleenohjausta.';
$strings['There were problems processing your request.'] = 'Syttmsi tiedon ksittely ei onnistunut.';
$strings['Please go back and correct any errors.'] = 'Ole hyv, ja korjaa virheet.';
$strings['Login to view details and place reservations'] = 'Kirjaudu sisn nhdksesi listietoja, ja listksesi varauksia.';
$strings['Memberid is not available.'] = 'Kyttj-id:t %s ei lytynyt.';

$strings['Schedule Title'] = 'Aikataulun otsikko';
$strings['Start Time'] = 'Aloitusaika';
$strings['End Time'] = 'Lopetusaika';
$strings['Time Span'] = 'Ajanjakso';
$strings['Weekday Start'] = 'Aloituspiv';
$strings['Admin Email'] = 'Yllpitjn shkpostiosoite';

$strings['Default'] = 'Vakio';
$strings['Reset'] = 'Palauta';
$strings['Edit'] = 'Muokkaa';
$strings['Delete'] = 'Poista';
$strings['Cancel'] = 'Peruuta';
$strings['View'] = 'Nyt';
$strings['Modify'] = 'Muuta';
$strings['Save'] = 'Tallenna';
$strings['Back'] = 'Edellinen';
$strings['Next'] = 'Seuraava';
$strings['Close Window'] = 'Sulje ikkuna';
$strings['Search'] = 'Etsi';
$strings['Clear'] = 'Tyhjenn';

$strings['Days to Show'] = 'Nytettv ajanjakso';
$strings['Reservation Offset'] = 'Varaussiirtym';
$strings['Hidden'] = 'Piilota';
$strings['Show Summary'] = 'Nyt yhteenveto';
$strings['Add Schedule'] = 'Lis aikatauluun';
$strings['Edit Schedule'] = 'Muokkaa aikataulua';
$strings['No'] = 'Ei';
$strings['Yes'] = 'Kyll';
$strings['Name'] = 'Nimi';
$strings['First Name'] = 'Etunimi';
$strings['Last Name'] = 'Sukunimi';
$strings['Resource Name'] = 'Resurssin nimi';
$strings['Email'] = 'Shkpostiosoite';
$strings['Institution'] = 'Jrjest/Yritys';
$strings['Phone'] = 'Puhelin';
$strings['Password'] = 'Salasana';
$strings['Permissions'] = 'Oikeudet';
$strings['View information about'] = 'Nyt tiedot: %s %s';
$strings['Send email to'] = 'Lhet shkpostia kyttjlle %s %s';
$strings['Reset password for'] = 'Nollaa kyttjn %s %s salasana';
$strings['Edit permissions for'] = 'Muokkaa kyttjn %s %s oikeuksia';
$strings['Position'] = 'Toimenkuva';
$strings['Password (6 char min)'] = 'Salasana (vhintn kuusi kirjainta)';
$strings['Re-Enter Password'] = 'Syt salasana uudelleen';

$strings['Sort by descending last name'] = 'Jrjest knten, sukunimen mukaan';
$strings['Sort by descending email address'] = 'Jrjest knten, shkpostiosoitteen mukaan';
$strings['Sort by descending institution'] = 'Jrjest knten, jrjestn/yrityksen mukaan';
$strings['Sort by ascending last name'] = 'Jrjest sukunimen mukaan';
$strings['Sort by ascending email address'] = 'Jrjest shkpostiosoitteen mukaan';
$strings['Sort by ascending institution'] = 'Jrjeste jrjestn/yrityksen mukaan';
$strings['Sort by descending resource name'] = 'Jrjest knten resurssin nimen mukaan';
$strings['Sort by descending location'] = 'Jrjest knten sijainnin mukaan';
$strings['Sort by descending schedule title'] = 'Jrjest knten aikataulun mukaan';
$strings['Sort by ascending resource name'] = 'Jrjest resurssin nimen mukaan';
$strings['Sort by ascending location'] = 'Jrjest sijainnin mukaan';
$strings['Sort by ascending schedule title'] = 'Jrjest aikataulun otsikon mukaan';
$strings['Sort by descending date'] = 'Jrjest knten pivmrn mukaan';
$strings['Sort by descending user name'] = 'Jrjest knten kyttjn nimen mukaan';
$strings['Sort by descending start time'] = 'Jrjest knten aloitusajankohdan mukaan';
$strings['Sort by descending end time'] = 'Jrjest knten lopetusajankohdan mukaan';
$strings['Sort by ascending date'] = 'Jrjest pivmrn mukaan';
$strings['Sort by ascending user name'] = 'Jrjest kyttjn nimen mukaan';
$strings['Sort by ascending start time'] = 'Jrjest aloitusajankohdan mukaan';
$strings['Sort by ascending end time'] = 'Jrjest lopetusajankohdan mukaan';
$strings['Sort by descending created time'] = 'Jrjest knten luontiajankohdan mukaan';
$strings['Sort by ascending created time'] = 'Jrjest luontiajankohdan mukaan';
$strings['Sort by descending last modified time'] = 'Jrjest knten muokkausajankohdan mukaan';
$strings['Sort by ascending last modified time'] = 'Jrjest muokkausajankohdan mukaan';

$strings['Search Users'] = 'Etsi kyttji';
$strings['Location'] = 'Sijainti';
$strings['Schedule'] = 'Aikataulu';
$strings['Notes'] = 'Muistiinpanot';
$strings['Status'] = 'Tila';
$strings['All Schedules'] = 'Kaikki aikataulut';
$strings['All Resources'] = 'Kaikki resurssit';
$strings['All Users'] = 'Kaikki kyttjt';

$strings['Edit data for'] = 'Muokkaa tietoja: %s';
$strings['Active'] = 'Aktiivinen';
$strings['Inactive'] = 'Inaktiivinen';
$strings['Toggle this resource active/inactive'] = 'Aseta aktiiviseksi/inaktiiviseksi';
$strings['Minimum Reservation Time'] = 'Vhimmisvarausaika';
$strings['Maximum Reservation Time'] = 'Enimmisvarausaika';
$strings['Auto-assign permission'] = 'Aseta oikeudet automaattisesti';
$strings['Add Resource'] = 'Lis resurssi';
$strings['Edit Resource'] = 'Muokkaa resurssia';
$strings['Allowed'] = 'Sallittu';
$strings['Notify user'] = 'Huomauta kyttj';
$strings['User Reservations'] = 'Kyttjvaraukset';
$strings['Date'] = 'Pivmr';
$strings['User'] = 'Kyttj';
$strings['Subject'] = 'Aihe';
$strings['Message'] = 'Viesti';
$strings['Please select users'] = 'Valitse kyttjt';
$strings['Send Email'] = 'Lhet shkpostia';
$strings['problem sending email'] = 'Shkpostin lhetys eponnistui surkeasti. Voit yritt uudelleen, mutta perinteisten viestintmenetelmien kytt on luultavasti nopeampaa.';
$strings['The email sent successfully.'] = 'Shkpostin lhetys onnistui.';
$strings['do not refresh page'] = '<u>l</u> lataa tt sivua uudelleen. Uudelleenlataus lhett viestin uudelleen.';
$strings['Return to email management'] = 'Palaa shkpostien hallintaan.';
$strings['Please select which tables and fields to export'] = 'Valitse vietvt taulut ja kentt:';
$strings['all fields'] = '- kaikki kentt -';
$strings['HTML'] = 'HTML';
$strings['Plain text'] = 'Pelkk teksti';
$strings['XML'] = 'XML';
$strings['CSV'] = 'CSV';
$strings['Export Data'] = 'Vie tietoja';
$strings['Reset Password for'] = 'Nollaa kyttjn %s salasana';
$strings['Please edit your profile'] = 'Ole hyv, ja muokkaa profiiliasi';
$strings['Please register'] = 'Ole hyv, ja rekisteridy';
$strings['Email address (this will be your login)'] = 'Shkpostiosoite (toimii mys kyttjtunnuksenasi)';
$strings['Keep me logged in'] = 'Pysyv sisnkirjautuminen <br/>(vaatii evsteit)';
$strings['Edit Profile'] = 'Muokkaa profiilia';
$strings['Please Log In'] = 'Kirjaudu sisn';
$strings['Email address'] = 'Shkpostiosoite';
$strings['First time user'] = 'Ensimminen kyttkertasi?';
$strings['Click here to register'] = 'Klikkaa tss rekisterityksesi';
$strings['Register for phpScheduleIt'] = 'Rekisteridy phpScheduleIt-kyttjksi';
$strings['Log In'] = 'Kirjaudu sisn';
$strings['View Schedule'] = 'Nyt aikataulu';
$strings['View a read-only version of the schedule'] = 'Nyt suojattu versio aikataulusta';
$strings['I Forgot My Password'] = 'Unohdin salasanani';
$strings['Retreive lost password'] = 'Palauta unohtunut salasana';
$strings['Get online help'] = 'Get online help';
$strings['Language'] = 'Kieli';
$strings['(Default)'] = '(Vakio)';

$strings['My Announcements'] = 'Ilmoitukseni';
$strings['My Reservations'] = 'Varaukseni';
$strings['My Permissions'] = 'Oikeuteni';
$strings['My Quick Links'] = 'Pikalinkit';
$strings['Announcements as of'] = '%s menness ilmestyneet ilmoitukset';
$strings['There are no announcements.'] = 'Ei ilmoituksia';
$strings['Resource'] = 'Resurssi';
$strings['Created'] = 'Luotu';
$strings['Last Modified'] = 'Muutettu viimeksi';
$strings['View this reservation'] = 'Nyt varaus';
$strings['Modify this reservation'] = 'Muokkaa varausta';
$strings['Delete this reservation'] = 'Poista varaus';
$strings['Bookings'] = 'Kirjaukset';
$strings['Change My Profile Information/Password'] = 'Muuta profiilia';		// @since 1.2.0
$strings['Manage My Email Preferences'] = 'Shkposti asetukset';		// @since 1.2.0
$strings['Mass Email Users'] = 'Lhet shkpostia monelle kyttjlle';
$strings['Search Scheduled Resource Usage'] = 'Etsi varauksia'; 		// @since 1.2.0
$strings['Export Database Content'] = 'Vie tietokannan sislt';
$strings['View System Stats'] = 'Nyt jrjestelmn tilastot';
$strings['Email Administrator'] = 'Lhet postia yllpitjlle';

$strings['Email me when'] = 'Lhet minulle postia, jos:';
$strings['I place a reservation'] = 'Teen varauksen';
$strings['My reservation is modified'] = 'Varaustani on muokattu';
$strings['My reservation is deleted'] = 'Varaukseni on postettu';
$strings['I prefer'] = 'Mieluiten:';
$strings['Your email preferences were successfully saved'] = 'Shkpostin asetukset tallennettu!';
$strings['Return to My Control Panel'] = 'Palaa ohjauspaneeliin';

$strings['Please select the starting and ending times'] = 'Valitse aloitus- ja lopetusajankohdat:';
$strings['Please change the starting and ending times'] = 'Muuta aloitus -ja lopetusajankohtia:';
$strings['Reserved time'] = 'Varausaika:';
$strings['Minimum Reservation Length'] = 'Vhimmisvarausaika:';
$strings['Maximum Reservation Length'] = 'Enimmisvarausaika:';
$strings['Reserved for'] = 'Varattu:';
$strings['Will be reserved for'] = 'Tulee olemaan varattuna:';
$strings['N/A'] = '-- Tyhj --';
$strings['Update all recurring records in group'] = 'Pivit kaikki ryhmn uusiutuvat tiedot?';
$strings['Delete?'] = 'Poista?';
$strings['Never'] = '-- Ei koskaan --';
$strings['Days'] = 'Piv';
$strings['Weeks'] = 'Viikkoa';
$strings['Months (date)'] = 'Kuukausia (pvm)';
$strings['Months (day)'] = 'Kuukausia (piv)';
$strings['First Days'] = 'Ensimmiset pivt';
$strings['Second Days'] = 'Toiset pivt';
$strings['Third Days'] = 'Kolmannet pivt';
$strings['Fourth Days'] = 'Neljnnet pivt';
$strings['Last Days'] = 'Viimeiset pivt';
$strings['Repeat every'] = 'Toista joka:';
$strings['Repeat on'] = 'Toista aina:';
$strings['Repeat until date'] = 'Toista kunnes:';
$strings['Summary'] = 'Yhteenveto';

$strings['View schedule'] = 'Nyt aikataulu:';
$strings['My Past Reservations'] = 'Menneet varaukset';
$strings['Other Reservations'] = 'Muut varaukset';
$strings['Other Past Reservations'] = 'Muut menneet varaukset';
$strings['Blacked Out Time'] = 'Poissa kytst ollut aika';
$strings['Set blackout times'] = 'Aseta pois kytst %s ajaksi, aina %s';
$strings['Reserve on'] = 'Varaa %s aina %s';
$strings['Prev Week'] = '&laquo; Ed. Viikko';
$strings['Jump 1 week back'] = 'Viikko taaksepin';
$strings['Prev days'] = '&#8249; Ed. %d piv';
$strings['Previous days'] = '&#8249; Edelliset %d piv';
$strings['This Week'] = 'Tm viikko';
$strings['Jump to this week'] = 'Siirry thn viikkoon';
$strings['Next days'] = 'Seuraavat %d piv &#8250;';
$strings['Next Week'] = 'Seuraava viikko &raquo;';
$strings['Jump To Date'] = 'Siirry pivn';
$strings['View Monthly Calendar'] = 'Nyt kuukausikalenteri';
$strings['Open up a navigational calendar'] = 'Avaa navigointikalenteri';

$strings['View stats for schedule'] = 'Nyt aikataulun tilastot:';
$strings['At A Glance'] = 'Mulkaisu';
$strings['Total Users'] = 'Kyttji yhteens:';
$strings['Total Resources'] = 'Resursseja yhteens:';
$strings['Total Reservations'] = 'Varauksia yhteens:';
$strings['Max Reservation'] = 'Varauksia enintn:';
$strings['Min Reservation'] = 'Varauksia vhintn:';
$strings['Avg Reservation'] = 'Varauksia keskimrin:';
$strings['Most Active Resource'] = 'Akiivisin resurssi:';
$strings['Most Active User'] = 'Aktiivisimmat kyttjt:';
$strings['System Stats'] = 'Jrjestelmtilasto:';
$strings['phpScheduleIt version'] = 'phpScheduleIt version:';
$strings['Database backend'] = 'Tietokantapalvelin:';
$strings['Database name'] = 'Tietokannan nimi:';
$strings['PHP version'] = 'PHP:n versio:';
$strings['Server OS'] = 'Palvelimen kyttjrjestelm:';
$strings['Server name'] = 'Palvelimen nimi:';
$strings['phpScheduleIt root directory'] = 'phpScheduleIt root-hakemisto:';
$strings['Using permissions'] = 'Kytetn oikeuksia:';
$strings['Using logging'] = 'Kytetn sisnkirjausta:';
$strings['Log file'] = 'Lokitiedosto:';
$strings['Admin email address'] = 'Yllpitjn shkpostiosoite:';
$strings['Tech email address'] = 'Teknisen avun shkpostiosoite:';
$strings['CC email addresses'] = 'Kopio shkpostiosoitteet:';
$strings['Reservation start time'] = 'Varauksen aloitusaika:';
$strings['Reservation end time'] = 'Varauksen lopetusaika:';
$strings['Days shown at a time'] = 'Pivt nytetn ajalla:';
$strings['Reservations'] = 'Varaukset';
$strings['Return to top'] = 'Palaa ylreunaan';
$strings['for'] = 'kohteelle';

$strings['Select Search Criteria'] = 'Valitse hakuehdot:';
$strings['Schedules'] = 'Aikataulut:';
$strings['Hold CTRL to select multiple'] = 'Pid pohjassa CTRL-nppint valitaksesi useampia';
$strings['Users'] = 'Kyttjt';
$strings['Resources'] = 'Resurssit';
$strings['Starting Date'] = 'Aloituspiv:';
$strings['Ending Date'] = 'Lopetuspiv:';
$strings['Starting Time'] = 'Aloitusaika:';
$strings['Ending Time'] = 'Lopetusaika:';
$strings['Output Type'] = 'Tulosteen tyyppi:';
$strings['Manage'] = 'Hallitse';
$strings['Total Time'] = 'Kytetty aika:';
$strings['Total hours'] = 'Yhteens tunteja:';
$strings['% of total resource time'] = '% kytetyst resurssiajasta.';
$strings['View these results as'] = 'Nyt resurssit seuraavasti:';
$strings['Edit this reservation'] = 'Muokkaa varausta';
$strings['Search Results'] = 'Haun tulokset';
$strings['Search Resource Usage'] = 'Etsi resurssien kytst';
$strings['Search Results found'] = 'Hakutulokset: %d varauksista lytynyt';
$strings['Try a different search'] = 'Yrit toista hakua';
$strings['Search Run On'] = 'Kyt hakua kohteeseen:';
$strings['Member ID'] = 'Kyttj-id';
$strings['Previous User'] = '&laquo; Edellinen kyttj';
$strings['Next User'] = 'Seuraava kyttj &raquo;';

$strings['No results'] = 'Ei tuloksia';
$strings['That record could not be found.'] = 'Tietoa ei lytynyt.';
$strings['This blackout is not recurring.'] = 'Tm kyttkatkos ei ole toistuva.';
$strings['This reservation is not recurring.'] = 'Tm varaus ei ole toistuva.';
$strings['There are no records in the table.'] = 'Taulussa %s ei ole tietoja.';
$strings['You do not have any reservations scheduled.'] = 'Aikataulussasi ei ole varauksia.';
$strings['You do not have permission to use any resources.'] = 'Sinulla ei ole oikeuksia resursseihin.';
$strings['No resources in the database.'] = 'Tietokannassa ei ole resursseja.';
$strings['There was an error executing your query'] = 'Kyselysi ksittely ptyi virheeseen.';

$strings['That cookie seems to be invalid'] = 'Evste ei ole kelvollinen ';
$strings['We could not find that email in our database.'] = 'Shkpostiosoitetta ei lytynyt tietokannasta.';
$strings['That password did not match the one in our database.'] = 'Shkposti ei vastannut tietokannassa olevaa.';
$strings['You can try'] = '<br />Voit:<br />Rekisterid shkpostiosoitteen.<br />Tai:<br />Yritt kirjautua uudelleen.';
$strings['A new user has been added'] = 'Uusi kyttj listty.';
$strings['You have successfully registered'] = 'Rekisterinti onnistui!';
$strings['Continue'] = 'Jatka...';
$strings['Your profile has been successfully updated!'] = 'Profiilisi on pivitetty!';
$strings['Please return to My Control Panel'] = 'Palaa ohjauspaneeliin';
$strings['Valid email address is required.'] = '- Vaaditaan kelvollinen shkpostiosoite';
$strings['First name is required.'] = '- Vaaditaan kelvollinen etunimi';
$strings['Last name is required.'] = '- Vaaditaan kelvollinen sukunimi';
$strings['Phone number is required.'] = '- Vaaditaan puhelinnumero';
$strings['That email is taken already.'] = '- Shkpostiosoite on jo kytss<br />Ole hyv, ja kyt jotain muuta osoitetta.';
$strings['Min 6 character password is required.'] = '- Salasanan on oltava vhint kuusi merkki pitk.';
$strings['Passwords do not match.'] = '- Salasanat eivt tsm.';

$strings['Per page'] = 'Per sivu:';
$strings['Page'] = 'Sivu:';

$strings['Your reservation was successfully created'] = 'Varauksesi luotiin onnistuneesti';
$strings['Your reservation was successfully modified'] = 'Varauksesi muokkaus onnistui';
$strings['Your reservation was successfully deleted'] = 'Varauksesi poistettiin onnistuneesti';
$strings['Your blackout was successfully created'] = 'Kyttkatko luotiin onnistuneesti';
$strings['Your blackout was successfully modified'] = 'Kyttkatkon muokkaus onnistui';
$strings['Your blackout was successfully deleted'] = 'Kyttkatko poistettiin onnistuneesti';
$strings['for the follwing dates'] = 'seuraaville piville:';
$strings['Start time must be less than end time'] = 'Aloitusajankohdan pit olla pienempi kuin lopetusajankohdan.';
$strings['Current start time is'] = 'Tmnhetkinen aloitusajankohta on:';
$strings['Current end time is'] = 'Tmnhetkinen lopetusajankohta on:';
$strings['Reservation length does not fall within this resource\'s allowed length.'] = 'Varauksen pituus ei ole sallitun pituuden rajoissa.';
$strings['Your reservation is'] = 'Varauksesi on:';
$strings['Minimum reservation length'] = 'Pienin sallittu varauksen pituus:';
$strings['Maximum reservation length'] = 'Suurin sallittu varauksen pituus:';
$strings['You do not have permission to use this resource.'] = 'Sinulla ei ole oikeuksia kytt tt resurssia.';
$strings['reserved or unavailable'] = '%s to %s is reserved or unavailable.';	// @since 1.1.0
$strings['Reservation created for'] = 'Varaus luotu ajalle %s';
$strings['Reservation modified for'] = 'Varaus muokattu ajalle %s';
$strings['Reservation deleted for'] = 'Varaus poistettu ajalle %s';
$strings['created'] = 'luotu';
$strings['modified'] = 'muokattu';
$strings['deleted'] = 'poistettu';
$strings['Reservation #'] = 'Varaus #';
$strings['Contact'] = 'Yhteys';
$strings['Reservation created'] = 'Varaus luotu';
$strings['Reservation modified'] = 'Varausta muokattu';
$strings['Reservation deleted'] = 'Varaus poistettu';

$strings['Reservations by month'] = 'Varaukset / kuukausi';
$strings['Reservations by day of the week'] = 'Varaukset / viikonpiv';
$strings['Reservations per month'] = 'Varauksia per kuukausi';
$strings['Reservations per user'] = 'Varauksia per kyttj';
$strings['Reservations per resource'] = 'Varauksia per resurssi';
$strings['Reservations per start time'] = 'Varauksia per aloitusajankohta';
$strings['Reservations per end time'] = 'Varauksia per lopetusajankohta';
$strings['[All Reservations]'] = '[Kaikki varaukset]';

$strings['Permissions Updated'] = 'Oikeudet pivitetty';
$strings['Your permissions have been updated'] = '%s -oikeutesi on pivitetty';
$strings['You now do not have permission to use any resources.'] = 'Sinulla ei ole oikeutta kytt resursseja.';
$strings['You now have permission to use the following resources'] = 'Sinulla on nyt oikeus kytt seuraavia resursseja:';
$strings['Please contact with any questions.'] = 'Yhteyshenkilsi ongelmatilanteissa on: %s';
$strings['Password Reset'] = 'Salasana nollattu';

$strings['This will change your password to a new, randomly generated one.'] = 'Tm vaihtaa salasanasi uuteen satunnaisesti luotuun.';
$strings['your new password will be set'] = 'Sytettysi shkpostiosoitteen, ja klikattuasi "Vaihda salasana"-nappia,  salasanasi pivitetn ja lhetetn sinulle shkpostilla.';
$strings['Change Password'] = 'Vaihda salasana';
$strings['Sorry, we could not find that user in the database.'] = 'Kyttj ei lytynyt tietokannasta.';
$strings['Your New Password'] = 'Uusi %s salasanasi';
$strings['Your new passsword has been emailed to you.'] = 'Uusi salasanasi on lhetetty sinulle shkpostila.<br />Saatuasi salasanan,<a href="index.php">kirjaudu sisn</a> kyttmll sit, ja vaihda salasana haluamaksesi klikkaamalla &quot;Muokkaa profiilin tietoja/salasanaa&quot; -linkki Ohjauspaneelissa.';
$strings['You are not logged in!'] = 'Et ole kirjautunut sisn!';

$strings['Setup'] = 'Asetukset';
$strings['Please log into your database'] = 'Kirjaudu tietokantaan';
$strings['Enter database root username'] = 'Syt tietokannan pkyttjtunnus:';
$strings['Enter database root password'] = 'Syt tietokannan pkyttj-salasana:';
$strings['Login to database'] = 'Kirjaudu tietokantaan';
$strings['Root user is not required. Any database user who has permission to create tables is acceptable.'] = 'Pkyttjtunnusta <b>ei</b> tarvita. Mik tahansa kyttjtunnus, jolla on oikeus luoda tauluja, toimii.';
$strings['This will set up all the necessary databases and tables for phpScheduleIt.'] = 'Luodaan kaikki tarpeelliset tietokannat ja taulut phpScheduleIt-ohjelmistolle.';
$strings['It also populates any required tables.'] = 'Mys kaikki tarvittavat taulut alustetaan.';
$strings['Warning: THIS WILL ERASE ALL DATA IN PREVIOUS phpScheduleIt DATABASES!'] = 'Varoitus: KAIKKI JO OLEMASSA TIETO phpScheduleIt -TIETOKANNOISSA POISTETAAN!';
$strings['Not a valid database type in the config.php file.'] = 'Tietokannan tyyppi tiedostossa config.php ei ole kelvollinen.';
$strings['Database user password is not set in the config.php file.'] = 'Tietokannan kyttjn salasanaa ei ole annettu config.php -tiedostossa.';
$strings['Database name not set in the config.php file.'] = 'Tietokannan nime ei ole annettu config.php-tiedostossa.';
$strings['Successfully connected as'] = 'Yhteys onnistui:';
$strings['Create tables'] = 'Luotaulut &gt;';
$strings['There were errors during the install.'] = 'Asennuksen aikana havaittiin virheit. On mahdollista, ett phpScheduleIt toimii tst huolimatta, jos virheet olivat pieni.<br/><br/>Lhet mahdolliset kysymykset SourceForge-<a href="http://sourceforge.net/forum/?group_id=95547">keskustelualuelle</a>.';
$strings['You have successfully finished setting up phpScheduleIt and are ready to begin using it.'] = 'phpScheduleIt-asennus onnistui. Voit alkaa kyttmn ohjelmistoa.';
$strings['Thank you for using phpScheduleIt'] = 'Muistathan poistaa \'install\'-hakemisto TYDELLISESTI. Tm on erityisen trke, sill hakemisto sislt salasanoja, ja muuta trke tietoa, joka mahdollistaa kenelle tahansa murtautumisen tietokantaan!<br /><br />Kiitos, ett valitsit phpScheduleIt:n!';
$strings['This will update your version of phpScheduleIt from 0.9.3 to 1.0.0.'] = 'Tm pivitt phpScheduleIt-version 0.9.3:sta versioksi 1.0.0';
$strings['There is no way to undo this action'] = 'Tt toimintoa ei voi peruuttaa!';
$strings['Click to proceed'] = 'Klikkaa jatkaaksesi!';
$strings['This version has already been upgraded to 1.0.0.'] = 'Tm versio on jo pivitetty versioksi 1.0.0';
$strings['Please delete this file.'] = 'Ole hyv, ja poista tm tiedosto.';
$strings['Patch completed successfully'] = 'Pivitys suoritettu onnistuneesti';
$strings['This will populate the required fields for phpScheduleIt 1.0.0 and patch a data bug in 0.9.9.'] = 'Tm alustaa tarvittavat kentt phpScheduleIt 1.0.0-versiolle, ja pivitt version 0.9.9 data-bugin.<br />Sinun tarvitsee ajaa tm vain, jos suoritit manuaalisen SQL-pivityksen, tai olet pivittmss versiosta 0.9.9';

// @since 1.0.0 RC1
$strings['If no value is specified, the default password set in the config file will be used.'] = 'Jos mitn arvoa ei ole mritetty, oletus salasanaa mritys tiedostosta tullaan kyttmn.';
$strings['Notify user that password has been changed?'] = 'Ilmoita kyttjlle salasanan vaihdosta?';

// @since 1.1.0
$strings['This system requires that you have an email address.'] = 'Tm jrjestelm vaatii, ett sinulla on shkpostiosoite.';
$strings['Invalid User Name/Password.'] = 'Vr kyttjtunnus/salasana.';
$strings['Pending User Reservations'] = 'Odottavat kyttjn varaukset';
$strings['Approve'] = 'Hyvksy';
$strings['Approve this reservation'] = 'Hyvksy tm varaus';
$strings['Approve Reservations'] ='Hyvksy varaukset';

$strings['Announcement'] = 'Tiedote';
$strings['Number'] = 'Numero';
$strings['Add Announcement'] = 'Lis tiedote';
$strings['Edit Announcement'] = 'Muokkaa tiedotetta';
$strings['All Announcements'] = 'Kaikki tiedotteet';
$strings['Delete Announcements'] = 'Poista tiedotteet';
$strings['Use start date/time?'] = 'Kyt aloitus pivmr/aikaa?';
$strings['Use end date/time?'] = 'Kyt lopetus pivmr/aikaa?';
$strings['Announcement text is required.'] = 'Tiedoite teksti vaaditaan.';
$strings['Announcement number is required.'] = 'Tiedoitteen numero vaaditaan.';

$strings['Pending Approval'] = 'Odottaa hyvksymist';
$strings['My reservation is approved'] = 'Varaukseni on hyvksytty';
$strings['This reservation must be approved by the administrator.'] = 'Pkyttjn pit hyvksy tm varaus.';
$strings['Approval Required'] = 'Hyvksynt vaaditaan';
$strings['No reservations requiring approval'] = 'Yksikn varaus ei odota hyvksynt';
$strings['Your reservation was successfully approved'] = 'Varauksesi on hyvksytty';
$strings['Reservation approved for'] = 'Varaus hyvksytty %s :lle';
$strings['approved'] = 'hyvksytty';
$strings['Reservation approved'] = 'Varaus hyvksytty';

$strings['Valid username is required'] = 'Voimassaoleva kyttjtunnus vaaditaan';
$strings['That logon name is taken already.'] = 'Kirjautumistunnus on jo kytss.';
$strings['this will be your login'] = '(Tm on kirjautumistunnuksesi)';
$strings['Logon name'] = 'Kirjautumistunnus';
$strings['Your logon name is'] = 'Kirjautumistunnuksesi on %s';

$strings['Start'] = 'Alkaa';
$strings['End'] = 'Pttyy';
$strings['Start date must be less than or equal to end date'] = 'Aloitus pivn tulee olla aikaisempi tai sama kuin pttymis pivn';
$strings['That starting date has already passed'] = 'Aloitus piv on jo mennyt';
$strings['Basic'] = 'Perus';
$strings['Participants'] = 'Osallistujat';
$strings['Close'] = 'Sulje';
$strings['Start Date'] = 'Aloitus piv';
$strings['End Date'] = 'Pttymis piv';
$strings['Minimum'] = 'Pienin';
$strings['Maximum'] = 'Suurin';
$strings['Allow Multiple Day Reservations'] = 'Salli useiden pivien varauksia';
$strings['Invited Users'] = 'Kutsutut kyttjt';
$strings['Invite Users'] = 'Kutsu kyttjia';
$strings['Remove Participants'] = 'Poista osallistujia';
$strings['Reservation Invitation'] = 'Varaus kutsu';
$strings['Manage Invites'] = 'Hallitse kutsuja';
$strings['No invite was selected'] = 'Yhtn kutsua ei ole valittu';
$strings['reservation accepted'] = '%s hyvksyi kutsusi: %s';
$strings['reservation declined'] = '%s ei hyvksynyt kutsuasi: %s';
$strings['Login to manage all of your invitiations'] = 'Kirjaudu hallitaksesi kaikkia kutsujasi';
$strings['Reservation Participation Change'] = 'Varauksen osanoton muuttaminen';
$strings['My Invitations'] = 'Kutsuni';
$strings['Accept'] = 'Hyvksy';
$strings['Decline'] = 'Hylk';
$strings['Accept or decline this reservation'] = 'Hyvksy tai hylk tm varaus';
$strings['My Reservation Participation'] = 'Varaukseni osanotto';
$strings['End Participation'] = 'Pt osanotto';
$strings['Owner'] = 'Omistaja';
$strings['Particpating Users'] = 'Osanottavat kyttjt';
$strings['No advanced options available'] = 'No advanced options available';
$strings['Confirm reservation participation'] = 'Vahvista varauksen osanotto';
$strings['Confirm'] = 'Vahvista';
$strings['Do for all reservations in the group?'] = 'Tee kaikille varauksille tss ryhmss?';

$strings['My Calendar'] = 'Kalenteri';
$strings['View My Calendar'] = 'Nyt kalenterini';
$strings['Participant'] = 'Osanotto';
$strings['Recurring'] = 'Pttymtn';
$strings['Multiple Day'] = 'Useita pivi';
$strings['[today]'] = '[tnn]';
$strings['Day View'] = 'Piv nkym';
$strings['Week View'] = 'Viikko nkym';
$strings['Month View'] = 'Kuukausi nkym';
$strings['Resource Calendar'] = 'Resurssi kalenteri';
$strings['View Resource Calendar'] = 'Aikataulu kalenteri';	// @since 1.2.0
$strings['Signup View'] = 'Kirjautumis nkym';

$strings['Select User'] = 'Valitse kyttj';
$strings['Change'] = 'Vaihda';

$strings['Update'] = 'Pivit';
$strings['phpScheduleIt Update is only available for versions 1.0.0 or later'] = 'phpScheduleIt pivitys on mahdollista vain versiolle 1.1.0 tai myhempi';
$strings['phpScheduleIt is already up to date'] = 'phpScheduleIt on jo ajantasalla';
$strings['Migrating reservations'] = 'Siirretn varauksia';

$strings['Admin'] = 'Pkyttj';
$strings['Manage Announcements'] = 'Hallitse tiedotteita';
$strings['There are no announcements'] = 'Ei yhtn tiedotetta';
// end since 1.1.0

// @since 1.2.0
$strings['Maximum Participant Capacity'] = 'Suurin osallistuja mr';
$strings['Leave blank for unlimited'] = 'Jt tyhjksi rajoittamatonta varten';
$strings['Maximum of participants'] = 'Tll resurssilla on suurin mahdollinnen mr (%s kpl) osallistujia';
$strings['That reservation is at full capacity.'] = 'Varaus on tynn.';
$strings['Allow registered users to join?'] = 'Salli rekistrityneiden kyttjien liitty?';
$strings['Allow non-registered users to join?'] = 'Salli rekistritymttmien kyttjien liitty?';
$strings['Join'] = 'Liity';
$strings['My Participation Options'] = 'Osallistumis valintani';
$strings['Join Reservation'] = 'Liity varaukseen';
$strings['Join All Recurring'] = 'Liity kaikkiin pttymttmsti';
$strings['You are not participating on the following reservation dates because they are at full capacity.'] = 'Et voi pit varausta kyseisin pivin, koska kaikki tilat on jo kytss.';
$strings['You are already invited to this reservation. Please follow participation instructions previously sent to your email.'] = 'Sinut on jo kutsuttu thn varaukseen. Ole hyv ja seuraa osallistumis ohjeita, jotka olivat shkpostissa.';
$strings['Additional Tools'] = 'Lis tykalut';
$strings['Create User'] = 'Luo kyttj';
$strings['Check Availability'] = 'Tarkista saatavuus';
$strings['Manage Additional Resources'] = 'Hallitse lis resursseja';
$strings['All Additional Resources'] = 'Kaikki lis resurssit';
$strings['Number Available'] = 'Kappaletta vapaana';
$strings['Unlimited'] = 'Loputon';
$strings['Add Additional Resource'] = 'Lis lis resurssi';
$strings['Edit Additional Resource'] = 'Muokkaa lis resurssia';
$strings['Checking'] = 'Tarkistaa';
$strings['You did not select anything to delete.'] = 'Et valinnut mitn poistettavaksi.';
$strings['Added Resources'] = 'Listyt resurssit';
$strings['Additional resource is reserved'] = 'Lis resurssi %s on ainoastaan saatavilla %s kerralla';
$strings['All Groups'] = 'Kaikki ryhmt';
$strings['Group Name'] = 'Ryhmn nimi';
$strings['Delete Groups'] = 'Poista ryhmt';
$strings['Manage Groups'] = 'Hallitse ryhmi';
$strings['None'] = 'Ei mitn';
$strings['Group name is required.'] = 'Ryhmn nimi vaaditaan.';
$strings['Groups'] = 'Ryhmt';
$strings['Current Groups'] = 'Tmn hetkiset ryhmt';
$strings['Group Administration'] = 'Ryhmn hallinta';
$strings['Reminder Subject'] = 'Varauksen muistutus - %s, %s %s';
$strings['Reminder'] = 'Muistutus';
$strings['before reservation'] = 'ennen varausta';
$strings['My Participation'] = 'Osallitumiset';
$strings['My Past Participation'] = 'Meneet osallistumiset';
$strings['Timezone'] = 'Aikavyhyke';
$strings['Export'] = 'Vie';
$strings['Select reservations to export'] = 'Valitse varaukset vietvksi';
$strings['Export Format'] = 'Vienti muoto';
$strings['This resource cannot be reserved less than x hours in advance'] = 'Tt resurssia ei voida varata pienemmksi kuin %s tunniksi ennakkoon';
$strings['This resource cannot be reserved more than x hours in advance'] = 'Tt resurssia ei voida varata pitemmksi kuin %s tunniksi ennakkoon';
$strings['Minimum Booking Notice'] = 'Pienin kirjauksen varoitus aika';
$strings['Maximum Booking Notice'] = 'Suurin kirjauksen varoitus aika';
$strings['hours prior to the start time'] = 'tuntia aloitus ajasta';
$strings['hours from the current time'] = 'tuntia tst hetkest';
$strings['Contains'] = 'Sislt';
$strings['Begins with'] = 'Alkaa';
$strings['Accessory Name'] = 'Lislaitteen nimi';
$strings['Accessories'] = 'Lislaitteet';
$strings['All Accessories'] = 'Kaikki lislaitteet';
$strings['Added Accessories'] = 'Listyt lislaitteet';
// end since 1.2.0

/***
  EMAIL MESSAGES
  Please translate these email messages into your language.  You should keep the sprintf (%s) placeholders
   in their current position unless you know you need to move them.
  All email messages should be surrounded by double quotes "
  Each email message will be described below.
***/
// @since 1.1.0
// Email message that a user gets after they register
$email['register'] = "%s, %s \r\n"
				. "Olet onnistuneesti rekistritynyt seuraavilla tiedoilla:\r\n"
				. "Tunnus: %s\r\n"
				. "Nimi: %s %s \r\n"
				. "Puhelin: %s \r\n"
				. "Jrjest/Yritys: %s \r\n"
				. "Toimenkuva: %s \r\n\r\n"
				. "Kirjaudu jrjestelmn oheisesta linkist:\r\n"
				. "%s \r\n\r\n"
				. "Lydt linkit kalenteriin ja muokataksesi tietojasi ohjauspaneelin kautta.\r\n\r\n"
				. "Ole hyv ja lhet kaikki resurssi ja varaus kysymyksesi osoitteeseen: %s";

// Email message the admin gets after a new user registers
$email['register_admin'] = "Yllpitj,\r\n\r\n"
				. "Uusi kyttj on rekisteritynyt seuraavin tiedoin:\r\n"
				. "Shkposti: %s \r\n"
				. "Nimi: %s %s \r\n"
				. "Puhelin: %s \r\n"
				. "Yritys/jrjest: %s \r\n"
				. "Toimenkuva: %s \r\n\r\n";

// First part of the email that a user gets after they create/modify/delete a reservation
// 'reservation_activity_1' through 'reservation_activity_6' are all part of one email message
//  that needs to be assembled depending on different options.  Please translate all of them.
// @since 1.1.0
$email['reservation_activity_1'] = "%s,\r\n<br />"
			. "Olet onnistuneesti varannut %s varausnumerolla #%s.\r\n\r\n<br/><br/>"
			. "Ole hyv ja kyt oheista varausnumeroa, jos sinulla on kysymyksi liittyen varaukseesi.\r\n\r\n<br/><br/>"
			. "Varaus on seuraavalla aikavlill: %s %s - %s %s seuraavaan tilaan: %s"
			. " joka sijaitsee %s on %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_2'] = "Tm varaus on toistettu seuraaville piville:\r\n<br/>";
$email['reservation_activity_3'] = "Kaikki toistuvat varaukset tss ryhmss %s mys.\r\n\r\n<br/><br/>";
$email['reservation_activity_4'] = "Varaukselle on annettu seuraavanlainen yhteenveto:\r\n<br/>%s\r\n\r\n<br/><br/>";
$email['reservation_activity_5'] = "Jos teit virheen, ole hyv, ja ota yhteytt yllpitjn osoitteessa: %s, tai soittamalla numeroon %s.\r\n\r\n<br/><br/>"
			. "Voit tutkia, tai muokata varaustietoja milloin tahansa kirjautumalla %s paikassa:\r\n<br/>"
			. "<a href=\"%s\" target=\"_blank\">%s</a>.\r\n\r\n<br/><br/>";
$email['reservation_activity_6'] = "Lhet tekniset kysymykset osoitteeseen <a href=\"mailto:%s\">%s</a>.\r\n\r\n<br/><br/>";
// @since 1.1.0
$email['reservation_activity_7'] = "%s,\r\n<br />"
			. "Varaus #%s on hyvksytty.\r\n\r\n<br/><br/>"
			. "Kyt tt varausnumeroa, kun otat yhteytt yllpitjn, miss tahansa kysymyksess.\r\n\r\n<br/><br/>"
			. "Varaus aikavlill %s %s - %s %s seuraavaan tilaan: %s"
			. " joka sijaitsee %s on %s.\r\n\r\n<br/><br/>";
			
// Email that the user gets when the administrator changes their password
$email['password_reset'] = "Yllpitj on nollannut %s -salasanasi.\r\n\r\n"
			. "Vliaikainen salasanasi on:\r\n\r\n %s\r\n\r\n"
			. "Kyt tt  vliaikaista salasanaa (kopio/liimaa ollaksesi varma oikeinkirjoituksesta) kirjautuaksesi %s paikassa %s ja vaihda salasana vlittmsti kyttmll Muokkaa profiilia/salasanaa -linkki pikalinkit-taulussa.\r\n\r\n"
			. "Ongelmatilanteissa kysymyksiisi vastaa %s.";

// Email that the user gets when they change their lost password using the 'Password Reset' form
$email['new_password'] = "%s,\r\nUusi salasana kyttjtilillesi %s on:\r\n\r\n"
			. "%s\r\n\r\n"
			. "Kirjaudu sisn (%s) tll salasanalla (kopioi-liit varmistaaksesi oikeinkirjoituksen), ja vaihda salasana haluamaksesi klikkaamalla Muokkaa profiilia/salasanaa -linkki Ohjauspaneelissa.\r\n\r\n"
			. "Ongelmatilanteissa kysymyksiisi vastaa %s.";
			
// @since 1.1.0
// Email that is sent to invite users to a reservation
$email['reservation_invite'] = "%s on kutsunut sinut osalliseksi seuraavaan varaukseen:\r\n\r\n"
		. "Resurssi: %s\r\n"
		. "Aloitus piv: %s\r\n"
		. "Aloitus aika: %s\r\n"
		. "Pttymis piv: %s\r\n"
		. "Pttymis aika: %s\r\n"
		. "Yhteenveto: %s\r\n"
		. "Toistetaan pivin (jos valittu): %s\r\n\r\n"
		. "Hyvksyksesi kutsun klikkaa linkki (kopio-liit, jollei linkki ole korostettu) %s\r\n"
		. "Hyltksesi kutsun klikkaa linkki (kopio-liit, jollei linkki ole korostettu) %s\r\n"
		. "Hyvksyksesi valitut pivt tai hallitaksesi kutsujasi myhemmin, kirjaudu sisn %s kyttjn %s";

// @since 1.1.0
// Email that is sent when a user is removed from a reservation
$email['reservation_removal'] = "Sinut on poistettu seuraavasta varauksesta:\r\n\r\n"
		. "Resurssi: %s\r\n"
		. "Aloitus piv: %s\r\n"
		. "Aloitus aika: %s\r\n"
		. "Pttymis piv: %s\r\n"
		. "Pttymis aika: %s\r\n"
		. "Yhteenveto: %s\r\n"
		. "Toistetaan pivin (jos valittu): %s\r\n\r\n";	

// @since 1.2.0
// Email body that is sent for reminders
$email['Reminder Body'] = "Varauksesi kohteesta %s alkaen %s %s - %s %s lhestyy.";
?>