<?php
/**
* French (fr) translation file.
* This also serves as the base translation file from which to derive
*
* @author Nick Korbel <lqqkout13@users.sourceforge.net>
* @translator J. Pe. <jpe@chez.com>
* @translator Kim Phan <kimphan@users.sourceforge.net>
* @translator Benoit Mortier <benoit.mortier@opensides.be>
* @version 05-14-06
* @package Languages
*
* Copyright (C) 2003 - 2007 phpScheduleIt
* License: GPL, see LICENSE
*/
///////////////////////////////////////////////////////////
// INSTRUCTIONS
///////////////////////////////////////////////////////////
// This file contains all of the strings that are used throughout phpScheduleit.
//
// To make phpScheduleIt available in another language, simply translate each
//  of the following strings into the appropriate one for the language.  Please be sure
//  to make the proper additions the /config/langs.php file (instructions are in the file).
//
// You will probably keep all sprintf (%s) tags in their current place.  These tags
//  are there as a substitution placeholder.  Please check the output after translating
//  to be sure that the sentences make sense.
//
// + Please use single quotes ' around all $strings.  If you need to use the ' character, please enter it as \'
// + Please use double quotes " around all $email.  If you need to use the " character, please enter it as \"
//
// + For all $dates please use the PHP strftime() syntax
//    http://us2.php.net/manual/en/function.strftime.php
//
// + Non-intuitive parts of this file will be explained with comments.  If you
//    have any questions, please email lqqkout13@users.sourceforge.net
//    or post questions in the Developers forum on SourceForge
//    http://sourceforge.net/forum/forum.php?forum_id=331297
///////////////////////////////////////////////////////////

////////////////////////////////
/* Do not modify this section */
////////////////////////////////
global $strings;			  //
global $email;				  //
global $dates;				  //
global $charset;			  //
global $letters;			  //
global $days_full;			  //
global $days_abbr;			  //
global $days_two;			  //
global $days_letter;		  //
global $months_full;		  //
global $months_abbr;		  //
global $days_letter;		  //
/******************************/

// Charset for this language
// 'iso-8859-1' will work for most languages
$charset = 'iso-8859-1';

/***
  DAY NAMES
  All of these arrays MUST start with Sunday as the first element
   and go through the seven day week, ending on Saturday
***/
// The full day name
$days_full = array('Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi');
// The three letter abbreviation
$days_abbr = array('Dim', 'Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam');
// The two letter abbreviation
$days_two  = array('Di', 'Lu', 'Ma', 'Me', 'Je', 'Ve', 'Sa');
// The one letter abbreviation
$days_letter = array('D', 'L', 'M', 'M', 'J', 'V', 'S');

/***
  MONTH NAMES
  All of these arrays MUST start with January as the first element
   and go through the twelve months of the year, ending on December
***/
// The full month name
$months_full = array('Janvier', 'Fvrier', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Aot', 'Septembre', 'Octobre', 'Novembre', 'Dcembre');
// The three letter month name
$months_abbr = array('Jan', 'Fev', 'Mar', 'Avr', 'Mai', 'Jun', 'Jul', 'Aou', 'Sep', 'Oct', 'Nov', 'Dec');

// All letters of the alphabet starting with A and ending with Z
$letters = array ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');

/***
  DATE FORMATTING
  All of the date formatting must use the PHP strftime() syntax
  You can include any text/HTML formatting in the translation
***/
// General date formatting used for all date display unless otherwise noted
$dates['general_date'] = '%d/%m/%Y';
// General datetime formatting used for all datetime display unless otherwise noted
// The hour:minute:second will always follow this format
$dates['general_datetime'] = '%d/%m/%Y @';
// Date in the reservation notification popup and email
$dates['res_check'] = '%A %d/%m/%Y';
// Date on the scheduler that appears above the resource links
$dates['schedule_daily'] = '%A,<br/>%d/%m/%Y';
// Date on top-right of each page
$dates['header'] = '%A, %B %d, %Y';
// Jump box format on bottom of the schedule page
// This must only include %m %d %Y in the proper order,
//  other specifiers will be ignored and will corrupt the jump box
$dates['jumpbox'] = '%d %m %Y';

/***
  STRING TRANSLATIONS
  All of these strings should be translated from the English value (right side of the equals sign) to the new language.
  - Please keep the keys (between the [] brackets) as they are.  The keys will not always be the same as the value.
  - Please keep the sprintf formatting (%s) placeholders where they are unless you are sure it needs to be moved.
  - Please keep the HTML and punctuation as-is unless you know that you want to change it.
***/
$strings['hours'] = 'heures';
$strings['minutes'] = 'minutes';
// The common abbreviation to hint that a user should enter the month as 2 digits
$strings['mm'] = 'mm';
// The common abbreviation to hint that a user should enter the day as 2 digits
$strings['dd'] = 'jj';
// The common abbreviation to hint that a user should enter the year as 4 digits
$strings['yyyy'] = 'aaaa';
$strings['am'] = 'am';
$strings['pm'] = 'pm';

$strings['Administrator'] = 'Administrateur';
$strings['Welcome Back'] = 'Bienvenue, %s';
$strings['Log Out'] = 'Quitter';
$strings['My Control Panel'] = 'Mon panneau de contrle';
$strings['Help'] = 'Aide';
$strings['Manage Schedules'] = 'Organisation de la planification';
$strings['Manage Users'] ='Gestion utilisateurs';
$strings['Manage Resources'] ='Gestion des Ressources';
$strings['Manage User Training'] ='Gestion de l\'entrainement des utilisateurs';
$strings['Manage Reservations'] ='Gestion des rservations';
$strings['Email Users'] ='Message lectronique aux utilisateurs';
$strings['Export Database Data'] = 'Exportation des donnes';
$strings['Reset Password'] = 'R-initialisation de mot de passe';
$strings['System Administration'] = 'Administration du systeme';
$strings['Successful update'] = 'Mise a jour russie';
$strings['Update failed!'] = 'Modification choue !';
$strings['Manage Blackout Times'] = 'Gestion du temps cach';
$strings['Forgot Password'] = 'Oubli du mot de passe';
$strings['Manage My Email Contacts'] = 'Gestion des mes correspondants';
$strings['Choose Date'] = 'Choisir une date';
$strings['Modify My Profile'] = 'Modification de mon profil';
$strings['Register'] = 'Enregistrer';
$strings['Processing Blackout'] = 'Execution du temps cach';
$strings['Processing Reservation'] = 'Mise en oeuvre des rservations';
$strings['Online Scheduler [Read-only Mode]'] = 'Planificateur en ligne [Mode lecture-seule]';
$strings['Online Scheduler'] = 'Planificateur en ligne';
$strings['phpScheduleIt Statistics'] = 'statistiques de phpScheduleIt';
$strings['User Info'] = 'Info Utilisateur:';

$strings['Could not determine tool'] = 'Outil non identifiable. S.V.P Essayez encore  partir du panneau de contrle.';
$strings['This is only accessable to the administrator'] = 'Ceci n\'est accessible qu\' l\'administrateur';
$strings['Back to My Control Panel'] = 'Retour  mon panneau de contrle';
$strings['That schedule is not available.'] = 'Cette planification n\'est pas disponible.';
$strings['You did not select any schedules to delete.'] = 'Vous n\'avez slectionn aucune planification  effacer.';
$strings['You did not select any members to delete.'] = 'Vous n\'avez slctionn aucun membre  supprimer.';
$strings['You did not select any resources to delete.'] = 'Vous n\'avez slctionn aucune ressource  supprimer.';
$strings['Schedule title is required.'] = 'La planification requiert un titre.';
$strings['Invalid start/end times'] = 'Heure de dbut ou de fin invalide';
$strings['View days is required'] = 'Jours de vision (?) requis';
$strings['Day offset is required'] = 'Plage horaire du jour requise';
$strings['Admin email is required'] = 'L\'adresse lectronique de l\'administrateur est requise';
$strings['Resource name is required.'] = 'Le nom de la ressource est requise.';
$strings['Valid schedule must be selected'] = 'Une planification valide est requise';
$strings['Minimum reservation length must be less than or equal to maximum reservation length.'] = 'Le temps minimum de rservation doit tre infrieur ou gal au temps de rservation maxium.';
$strings['Your request was processed successfully.'] = 'Votre demande a t correctement enregistre.';
$strings['Go back to system administration'] = 'Retour  l\'administration du systme.';
$strings['Or wait to be automatically redirected there.'] = 'ou attendre d\'y tre automatiquement redirig.';
$strings['There were problems processing your request.'] = 'Des difficults ont t rencontres lors de l\'excution de votre demande.';
$strings['Please go back and correct any errors.'] = 'Merci de bien vouloir retourner corriger les erreurs eventuelles.';
$strings['Login to view details and place reservations'] = 'Connectez vous pour voir les dtails et effectuer des rservations';
$strings['Memberid is not available.'] = 'L\'identifiant de l\'utilisateur: %s n\'est pas disponible.';

$strings['Schedule Title'] = 'Titre de la planification';
$strings['Start Time'] = 'Heure de dbut';
$strings['End Time'] = 'Heure de fin';
$strings['Time Span'] = 'Dure';
$strings['Weekday Start'] = 'Jour de dbut';
$strings['Admin Email'] = 'Adresse de messagerie de l\'administrateur';

$strings['Default'] = 'Dfaut';
$strings['Reset'] = 'R-initialisation';
$strings['Edit'] = 'Mise  jour';
$strings['Delete'] = 'Effacement';
$strings['Cancel'] = 'Annulation';
$strings['View'] = 'Visualisation';
$strings['Modify'] = 'Modification';
$strings['Save'] = 'Sauvegarde';
$strings['Back'] = 'Retour';
$strings['Next'] = 'Suivant';
$strings['Close Window'] = 'Fermeture de fentre';
$strings['Search'] = 'Recherche';
$strings['Clear'] = 'Effacement';

$strings['Days to Show'] = 'Jours  visualiser';
$strings['Reservation Offset'] = 'Priode de rservation';
$strings['Hidden'] = 'Cach';
$strings['Show Summary'] = 'Visualisation du sommaire';
$strings['Add Schedule'] = 'Ajout d\'une planification';
$strings['Edit Schedule'] = 'Modification d\'une planification';
$strings['No'] = 'Non';
$strings['Yes'] = 'Oui';
$strings['Name'] = 'Nom';
$strings['First Name'] = 'Prnom';
$strings['Last Name'] = 'Nom de famille';
$strings['Resource Name'] = 'Nom de la Ressource';
$strings['Email'] = 'Adresse de messagerie';
$strings['Institution'] = 'Socit';
$strings['Phone'] = 'Tlphone';
$strings['Password'] = 'Mot de passe';
$strings['Permissions'] = 'Permissions';
$strings['View information about'] = 'Visualisation des information de %s %s';
$strings['Send email to'] = 'Envoi d\'un message lectronique   %s %s';
$strings['Reset password for'] = 'R-initialisation du mot de passe de %s %s';
$strings['Edit permissions for'] = 'Modification des privilges pour %s %s';
$strings['Position'] = 'Position';
$strings['Password (6 char min)'] = 'Mot de passe (%s char min)';
$strings['Re-Enter Password'] = 'Re-Entrer le mot de passe';

$strings['Sort by descending last name'] = 'Tri dcroissant par nom de famille';
$strings['Sort by descending email address'] = 'Tri dcroissant par adresse lectronique';
$strings['Sort by descending institution'] = 'Tri dcroissant par socit';
$strings['Sort by ascending last name'] = 'Tri croissant par nom de famille';
$strings['Sort by ascending email address'] = 'Tri croissant par adresse lctronique';
$strings['Sort by ascending institution'] = 'Tri croissant par socit';
$strings['Sort by descending resource name'] = 'Tri dcroissant par nom de ressource';
$strings['Sort by descending location'] = 'Tri dcroissant par emplacement';
$strings['Sort by descending schedule title'] = 'Tri dcroissant par titre de planification';
$strings['Sort by ascending resource name'] = 'Tri croissant par nom de ressource';
$strings['Sort by ascending location'] = 'Tri croissant par emplacement';
$strings['Sort by ascending schedule title'] = 'Tri croissant pat titre de planification';
$strings['Sort by descending date'] = 'Tri dcroissant par date';
$strings['Sort by descending user name'] = 'Tri dcroissant par nom d\'utilisateur';
// duplicate $strings['Sort by descending resource name'] = 'Tri dcroissant par nom de ressource';
$strings['Sort by descending start time'] = 'Tri dcroissant par heure de dbut';
$strings['Sort by descending end time'] = 'Tri dcroissant par heure de fin';
$strings['Sort by ascending date'] = 'Tri croissant par date';
$strings['Sort by ascending user name'] = 'Tri croissant par nom d\'utilisateur';
$strings['Sort by ascending resource name'] = 'Tri croissant par nom de ressource';
$strings['Sort by ascending start time'] = 'Tri croissant par heure de dbut';
$strings['Sort by ascending end time'] = 'Tri croissant par heure de fin';
$strings['Sort by descending created time'] = 'Tri dcroissant par date de cration';
$strings['Sort by ascending created time'] = 'Tri croissant par date de cration';
$strings['Sort by descending last modified time'] = 'Tri dcroissant par heure de dernire modification';
$strings['Sort by ascending last modified time'] = 'Tri croissant par heure de dernire modification';

$strings['Search Users'] = 'Recherche utilisateurs';
$strings['Location'] = 'Emplacement';
$strings['Schedule'] = 'Planification';
$strings['Phone'] = 'Tlphone';
$strings['Notes'] = 'Notes';
$strings['Status'] = 'Etat';
$strings['All Schedules'] = 'Toutes planifications';
$strings['All Resources'] = 'Toutes ressources';
$strings['All Users'] = 'Tout utilisateurs';

$strings['Edit data for'] = 'Modification des donnes pour %s';
$strings['Active'] = 'Actif';
$strings['Inactive'] = 'Inactif';
$strings['Toggle this resource active/inactive'] = 'Bascule cette ressource active/inactive';
$strings['Minimum Reservation Time'] = 'Priode minimum de reservation';
$strings['Maximum Reservation Time'] = 'Priode maximum de reservation';
$strings['Auto-assign permission'] = 'Accord de permission automatique';
$strings['Add Resource'] = 'Ajout d\'une Ressource';
$strings['Edit Resource'] = 'Modification d\'une Ressource';
$strings['Allowed'] = 'Permis';
$strings['Notify user'] = 'Notification utilisateur';
$strings['User Reservations'] = 'Reservations de l\'utilisateur';
$strings['Date'] = 'Date';
$strings['User'] = 'Utilisateur';
$strings['Email Users'] = 'Adresse lectronique de l\'utilisateur';
$strings['Subject'] = 'Sujet';
$strings['Message'] = 'Message';
$strings['Please select users'] = 'S.V.P. slectionner un/des utilisateurs';
$strings['Send Email'] = 'Envoi du message lectronique';
$strings['problem sending email'] = 'Dsol, des difficults on ts rencontres lors de l\'envoi du message. S.V.P. Essayez de nouveau plus tard.';
$strings['The email sent successfully.'] = 'Le message lectronique a t envoy avec succs.';
$strings['do not refresh page'] = 'S.V.P <u>ne pas</u> r-actualiser cette page. Le faire enverait deux fois le message.';
$strings['Return to email management'] = 'Retour  la gestion des messages lectroniques';
$strings['Please select which tables and fields to export'] = 'Merci de choisir les tables et les champs  exporter :';
$strings['all fields'] = '- tous les champs -';
$strings['HTML'] = 'HTML';
$strings['Plain text'] = 'Texte brut';
$strings['XML'] = 'XML';
$strings['CSV'] = 'CSV';
$strings['Export Data'] = 'Exporter les donnes';
$strings['Reset Password for'] = 'R-initialisation du mot de passe de  %s';
$strings['Please edit your profile'] = 'Merci de mettre votre profile  jour';
$strings['Please register'] = 'Merci de vous enregister';
$strings['Email address (this will be your login)'] = 'Adresse lectronique (Ce sera votre nom de connexion)';
$strings['Keep me logged in'] = 'Maintenir ma connexion <br/>(utilisation de cookies requise )';
$strings['Edit Profile'] = 'Modification du profil';
$strings['Register'] = 'Enregistrer';
$strings['Please Log In'] = 'Merci de vous identifier';
$strings['Email address'] = 'Adresse lectronique';
$strings['Password'] = 'Mot de passe';
$strings['First time user'] = 'Si vous venez pour la premire fois?';
$strings['Click here to register'] = 'Cliquez ici pour vous enregistrer';
$strings['Register for phpScheduleIt'] = 'S\'enregistrer pour phpScheduleIt';
$strings['Log In'] = 'Se connecter';
$strings['View Schedule'] = 'Visualisation de planification';
$strings['View a read-only version of the schedule'] = 'Visualisation d\'une version en lecture seule d\'une planification';
$strings['I Forgot My Password'] = 'J\'ai oubli mon mot de passe';
$strings['Retreive lost password'] = 'Rcuprer un mot de passe oubli';
$strings['Get online help'] = 'Obtenir de l\'aide en ligne';
$strings['Language'] = 'Langage';
$strings['(Default)'] = '(Dfaut)';

$strings['My Announcements'] = 'Mes annonces';
$strings['My Reservations'] = 'Mes reservations';
$strings['My Permissions'] = 'Mes privilges';
$strings['My Quick Links'] = 'Mes liens rapides';
$strings['Announcements as of'] = 'Annonces de  %s';
$strings['There are no announcements.'] = 'Il n\'y pas d\'annonces.';
$strings['Resource'] = 'Ressource';
$strings['Created'] = 'Cr';
$strings['Last Modified'] = 'Dernire modification';
$strings['View this reservation'] = 'Visualisation de cette reservation';
$strings['Modify this reservation'] = 'Modification de cette reservation';
$strings['Delete this reservation'] = 'Effacement de cette reservation';
$strings['Go to the Online Scheduler'] = 'Allez sur le planificateur en ligne';
$strings['Change My Profile Information/Password'] = 'Changer mon Profil/Mot de passe';		// @since 1.2.0
$strings['Manage My Email Preferences'] = 'Prferences de messagerie';				// @since 1.2.0
$strings['Manage Blackout Times'] = 'Gestion du temps masqu';
$strings['Mass Email Users'] = 'Publipostage';
$strings['Search Scheduled Resource Usage'] = 'Chercher le taux d\'utilisation de la ressource rserve';		// @since 1.2.0
$strings['Export Database Content'] = 'Exportation du contenu de la base de donnes';
$strings['View System Stats'] = 'Visuallisation des statistiques systmes';
$strings['Email Administrator'] = 'Envoi d\'un message lectronique  l\'administrateur';

$strings['Email me when'] = 'M\'envoyer un message lectronique chaque fois que :';
$strings['I place a reservation'] = 'j\'effectue une reservation';
$strings['My reservation is modified'] = 'ma rservation est modifie';
$strings['My reservation is deleted'] = 'ma rservation est efface';
$strings['I prefer'] = 'Je prfre:';
$strings['Your email preferences were successfully saved'] = 'Vos messages lectronique ont ts sauvegards!';
$strings['Return to My Control Panel'] = 'Retour  mon Panneau de contrle';

$strings['Please select the starting and ending times'] = 'Merci de choisir les heures de dbut et de fin :';
$strings['Please change the starting and ending times'] = 'Merci de modifier les heures de dbut et de fin';
$strings['Reserved time'] = 'Heure de rservation :';
$strings['Minimum Reservation Length'] = 'Dure minimum de rservation :';
$strings['Maximum Reservation Length'] = 'Dure maximum de rservation :';
$strings['Reserved for'] = 'Rserv pour :';
$strings['Will be reserved for'] = 'sera rserv pour:';
$strings['N/A'] = 'N/A';
$strings['Update all recurring records in group'] = 'Modifie tous les enregistrements cycliques dans le groupe?';
$strings['Delete?'] = 'Efface ?';
$strings['Never'] = '-- Jamais --';
$strings['Days'] = 'Jours';
$strings['Weeks'] = 'Semaines';
$strings['Months (date)'] = 'Mois (date)';
$strings['Months (day)'] = 'Mois (jour)';
$strings['First Days'] = 'Premiers jour';
$strings['Second Days'] = 'Second jour';
$strings['Third Days'] = 'Troisime jour';
$strings['Fourth Days'] = 'Quatrime jour';
$strings['Last Days'] = 'Dernier jour';
$strings['Repeat every'] = 'Rpte tous les :';
$strings['Repeat on'] = 'Rpete chaque:';
$strings['Repeat until date'] = 'Rpte juqu\' :';
$strings['Choose Date'] = 'Choisir une date';
$strings['Summary'] = 'Rsum';

$strings['View schedule'] = 'Visualisation de la planification:';
$strings['My Reservations'] = 'Mes rservations';
$strings['My Past Reservations'] = 'Mes anciennes rservations';
$strings['Other Reservations'] = 'Les autres reservations';
$strings['Other Past Reservations'] = 'Les autes anciennes rservations';
$strings['Blacked Out Time'] = 'Temps masqu';
$strings['Set blackout times'] = 'Etablissement du temps masqu %s sur %s';
$strings['Reserve on'] = 'Reserve %s sur %s';
$strings['Prev Week'] = '&laquo; Sem. Prc.';
$strings['Next Week'] = 'Sem. Suiv. &raquo;';
$strings['Jump 1 week back'] = 'Sauter 1 Sem. en Arr.';
$strings['Prev days'] = '&#8249; %d jours prc.';
$strings['Previous days'] = '&#8249; %d jours prcdents';
$strings['This Week'] = 'Cette semaine';
$strings['Jump to this week'] = 'ALler  cette semaine';
$strings['Next days'] = 'prochains %d jours &#8250;';
$strings['Jump To Date'] = 'Aller  cette date';
$strings['View Monthly Calendar'] = 'Visualisation du calendrier mensuel';
$strings['Open up a navigational calendar'] = 'Ouverture du calendrier de navigation';

$strings['View stats for schedule'] = 'Visualisation des statistique pour la planification:';
$strings['At A Glance'] = 'D\'un coup d\'oeil';
$strings['Total Users'] = 'Total utilisateurs:';
$strings['Total Resources'] = 'Total Ressources:';
$strings['Total Reservations'] = 'Total Reservations:';
$strings['Max Reservation'] = 'Max Reservation:';
$strings['Min Reservation'] = 'Min Reservation:';
$strings['Avg Reservation'] = 'Moy Reservation:';
$strings['Most Active Resource'] = 'Ressource la plus active :';
$strings['Most Active User'] = 'L\'utilisateur le plus actif :';
$strings['System Stats'] = 'Statistiques systmes';
$strings['phpScheduleIt version'] = 'phpScheduleIt version:';
$strings['Database backend'] = 'Base de donnes principale :';
$strings['Database name'] = 'Nom de base de donnes :';
$strings['PHP version'] = 'PHP version:';
$strings['Server OS'] = 'Server OS:';
$strings['Server name'] = 'Server name:';
$strings['phpScheduleIt root directory'] = 'rpertoire racine de phpScheduleIt:';
$strings['Using permissions'] = 'Utilise les permissions:';
$strings['Using logging'] = 'Utilise les fichiers historiques:';
$strings['Log file'] = 'Fichier historique :';
$strings['Admin email address'] = 'Adresse de messagerie administrateur:';
$strings['Tech email address'] = 'Adresse de messagerie technique:';
$strings['CC email addresses'] = 'Adresses de messagerie  CC:';
$strings['Reservation start time'] = 'Heure de dbut de reservation :';
$strings['Reservation end time'] = 'Heure de fin de reservation :';
$strings['Days shown at a time'] = 'Nombre de jours visualiss d\'un coup:';
$strings['Reservations'] = 'Rservations';
$strings['Return to top'] = 'Retour en haut';
$strings['for'] = 'pour';

$strings['Select Search Criteria'] = 'Choix des critres de slection';
$strings['Schedules'] = 'Planifications:';
$strings['All Schedules'] = 'Toutes planifications';
$strings['Hold CTRL to select multiple'] = 'Maintenir la touche CTRL pour un choix multiple';
$strings['Users'] = 'Utilisateurs :';
$strings['All Users'] = 'Tout utilisateurs';
$strings['Resources'] = 'Ressources';
$strings['All Resources'] = 'Toutes Ressources';
$strings['Starting Date'] = 'Date de dbut :';
$strings['Ending Date'] = 'Date de fin :';
$strings['Starting Time'] = 'Heure de dbut :';
$strings['Ending Time'] = 'Heure de fin :';
$strings['Output Type'] = 'Type d\'affichage :';
$strings['Manage'] = 'Grer';
$strings['Total Time'] = 'Temps total :';
$strings['Total hours'] = 'Heures totales :';
$strings['% of total resource time'] = '% du temps de ressource total';
$strings['View these results as'] = 'Visualisation de ce rsultat comme :';
$strings['Edit this reservation'] = 'Modifie cette rservation';
$strings['Search Results'] = 'Rsultats de la recherche';
$strings['Search Resource Usage'] = 'Cherche l\'utilisation des ressources';
$strings['Search Results found'] = 'Rsultats de la recherche: %d reservations trouves';
$strings['Try a different search'] = 'Essayer une recherche diffrente';
$strings['Search Run On'] = 'La recherche s\'effectue sur :';
$strings['Member ID'] = 'Member ID';
$strings['Previous User'] = '&laquo; Utilisateur prcdent';
$strings['Next User'] = 'Utilisateur suivant &raquo;';

$strings['No results'] = 'Pas de rsultat';
$strings['That record could not be found.'] = 'Cet enregistrement ne peut tre trouv.';
$strings['This blackout is not recurring.'] = 'Ce temps masqu ne se reproduit pas.';
$strings['This reservation is not recurring.'] = 'Cette rservation n\'est pas cyclique.';
$strings['There are no records in the table.'] = 'Il n\'y a aucun enregistrements dans cette table %s.';
$strings['You do not have any reservations scheduled.'] = 'Vous n\'avez aucune reservation planifie.';
$strings['You do not have permission to use any resources.'] = 'Vous n\'avez pas la permission d\'utilser les ressources.';
$strings['No resources in the database.'] = 'Il n\'y a aucune ressource dfinie dans la base de donnes.';
$strings['There was an error executing your query'] = 'Une erreur s\'est produite lors de l\'excution du la requte:';

$strings['That cookie seems to be invalid'] = 'Ce cookie semble invalide';
$strings['We could not find that logon in our database.'] = 'Identifiant de connexion inconnu dans notre database.';  // @since 1.1.0
$strings['That password did not match the one in our database.'] = 'Le mot de passe n\'est pas identique  celui contenu dans la base de donnes.';
$strings['You can try'] = '<br />Vous pouvez essayer:<br />d\'enregister une adresse email.<br />Ou :<br />Essayer de vous connecter  nouveau.';
$strings['A new user has been added'] = 'Un nouvel utilisateur a t ajout';
$strings['You have successfully registered'] = 'Vous avez t enregistr correctement!';
$strings['Continue'] = 'Continuer...';
$strings['Your profile has been successfully updated!'] = 'Votre profil a t correctement modifi!';
$strings['Please return to My Control Panel'] = 'Merci de retourner au panneau de contrle';
$strings['Valid email address is required.'] = '- Une adresse lectronique valide est requise.';
$strings['First name is required.'] = '- Le prnom est requis.';
$strings['Last name is required.'] = '- Le nom de famille est requis.';
$strings['Phone number is required.'] = '- Le numro de tlphone est requis.';
$strings['That email is taken already.'] = '- Cet adresse lectronique est dj utilise.<br />Merci d\'essayer de nouveau avec une autre adresse lectronique.';
$strings['Min 6 character password is required.'] = '- Le mot de passe requiert un minimum de %s caractres.';
$strings['Passwords do not match.'] = '- Les mots de passe ne correspondent pas.';

$strings['Per page'] = 'Par page:';
$strings['Page'] = 'Page:';

$strings['Your reservation was successfully created'] = 'Votre rservation a t correctement enregistre';
$strings['Your reservation was successfully modified'] = 'Votre rservation a t correctement modifie';
$strings['Your reservation was successfully deleted'] = 'Votre rservation a t correctement efface';
$strings['Your blackout was successfully created'] = 'Votre temps masqu a t correctement cr';
$strings['Your blackout was successfully modified'] = 'Votre temps masqu a t correctement modifi';
$strings['Your blackout was successfully deleted'] = 'Votre temps masqu a t correctement effac';
$strings['for the follwing dates'] = 'pour les dates suivantes:';
$strings['Start time must be less than end time'] = 'L\'heure de dbut doit tre infrieure  l\'heure de fin.';
$strings['Current start time is'] = 'L\'actuelle heure de dbut est :';
$strings['Current end time is'] = 'L\'actuelle heure de fin est :';
$strings['Reservation length does not fall within this resource\'s allowed length.'] = 'La dure de reservation n\'est pas compatible avec la dure de rservation autorise.';
$strings['Your reservation is'] = 'Votre rservation est :';
$strings['Minimum reservation length'] = 'Dure minimum de rservation :';
$strings['Maximum reservation length'] = 'Dure maximum de rservation :';
$strings['You do not have permission to use this resource.'] = 'Vous n\'avez pas les droits d\'utilisation de cette ressource.';
$strings['reserved or unavailable'] = '%s  %s est reserv ou indisponible.';   // @since 1.1.0
$strings['Reservation created for'] = 'Reservation cr pour %s';
$strings['Reservation modified for'] = 'Reservation modifie pour %s';
$strings['Reservation deleted for'] = 'Reservation efface %s';
$strings['created'] = 'cr';
$strings['modified'] = 'modifi';
$strings['deleted'] = 'effac';
$strings['Reservation #'] = 'Reservation #';
$strings['Contact'] = 'Contact';
$strings['Reservation created'] = 'Reservation cr';
$strings['Reservation modified'] = 'Reservation modifie';
$strings['Reservation deleted'] = 'Reservation efface';

$strings['Reservations by month'] = 'Rservations par mois';
$strings['Reservations by day of the week'] = 'Rservations par jour de la semaine';
$strings['Reservations per month'] = 'Rservations par mois';
$strings['Reservations per user'] = 'Rservations par utilisateur';
$strings['Reservations per resource'] = 'Rservations par ressource';
$strings['Reservations per start time'] = 'Rservations par date de dbut';
$strings['Reservations per end time'] = 'Rservations par date de fin';
$strings['[All Reservations]'] = 'Toutes les rservations';

$strings['Permissions Updated'] = 'Privilges modifis';
$strings['Your permissions have been updated'] = 'Vos %s privilges ont t modifis';
$strings['You now do not have permission to use any resources.'] = 'Vous n\'avez les droits d\'utilisation d\'aucune ressource.';
$strings['You now have permission to use the following resources'] = 'Vous avez dsormais les droits d\'utilisation des ressources suivantes :';
$strings['Please contact with any questions.'] = 'Merci de contacter %s pour toutes questions.';
$strings['Password Reset'] = 'R-initialisation du mot de passe';

$strings['This will change your password to a new, randomly generated one.'] = 'Cela remplacera votre mot de passe par un mot de passe dtermin de faon alatoire.';
$strings['your new password will be set'] = 'Aprs avoir indiqu votre adresse lectronique et cliqu sur "Modification du mot de passe", votre nouveau mot de passe sera effectif et vous sera envoy.';
$strings['Change Password'] = 'Modification du mot de passe';
$strings['Sorry, we could not find that user in the database.'] = 'Dsol nous ne pouvons trouver cet utilisateur dans notre base de donnes.';
$strings['Your New Password'] = 'Votre nouveau mot de passe %s ';
$strings['Your new passsword has been emailed to you.'] = 'Succs!<br />
          Votre nouveau mot de passe vous a t envoy par message lectronique.<br />
          Merci de contrler le contenu de votre boite aux lettres, puis <a href="index.php">Connectez vous</a>
          avec votre nouveau mot de passe et modifiez le en cliquant &quot;Modifie les information de mon profil/mot de passe&quot;
          dans mon Panneau de contrle.';

$strings['You are not logged in!'] = 'Vous n\'tes pas connect!';

$strings['Setup'] = 'Installation';
$strings['Please log into your database'] = 'Merci de vous connecter  votre base de donnes';
$strings['Enter database root username'] = 'Indiquez le nom de l\'administrateur de la base de donnes:';
$strings['Enter database root password'] = 'Indiquez le mot de passe de l\'administrateur de la base de donnes:';
$strings['Login to database'] = 'Connexion  la base de donnes';
$strings['Root user is not required. Any database user who has permission to create tables is acceptable.'] = 'L\'administrateur  <b>n\'est pas </b> requis. Tout utilisateur qui a les droits de cration de tables est suffisant.';
$strings['This will set up all the necessary databases and tables for phpScheduleIt.'] = 'Cela va installer toutes les bases et tables ncessaire  phpScheduleIt.';
$strings['It also populates any required tables.'] = 'Cela remplit galement toutes les tables ncessaires.';
$strings['Warning: THIS WILL ERASE ALL DATA IN PREVIOUS phpScheduleIt DATABASES!'] = 'Attention: CELA VA EFFACER TOUTES LES DONNEES DANS LES BASES DE DONNEES PRECEDENTES DE phpScheduleIt !';
$strings['Not a valid database type in the config.php file.'] = 'Un type de base de donne invalide figure dans le script config.php.';
$strings['Database user password is not set in the config.php file.'] = 'Le mot de passe d\'accs  la base de donne n\'est pas indiqu dans config.php.';
$strings['Database name not set in the config.php file.'] = 'Le nom de la base de donne n\'est pas indiqu dans config.php.';
$strings['Successfully connected as'] = 'Connect avec succs en tant que ';
$strings['Create tables'] = 'Cr les tables &gt;';
$strings['There were errors during the install.'] = 'Des erreurs se sont produites durant l\'installation. Il est possible que phpScheduleIt fonctionne correctement si les erreurs sont mineures.<br/><br/>'
  . 'Merci de poser toute question sur le forum <a href="http://sourceforge.net/forum/?group_id=95547">SourceForge</a>.';
$strings['You have successfully finished setting up phpScheduleIt and are ready to begin using it.'] = 'Vous avez termin d\'installer phpScheduleIt avec succs et tes prt  l\'utiliser.';
$strings['Thank you for using phpScheduleIt'] = 'Merci de vous assurer de dtruire le rpertoire \'install\'.'
  . ' C\'est essentiel car il contient des informations confidentielles d\'accs.'
  . ' Ne pas agir ainsi vous expose  des intrusions malveilantes de nature  dtruire votre site !'
  . '<br /><br />'
  . 'Merci d\'utiliser phpScheduleIt!';
$strings['This will update your version of phpScheduleIt from 0.9.3 to 1.0.0.'] = 'Ceci va mettre  jour votre phpScheduleIt de la verion 0.9.3  1.0.0.';
$strings['There is no way to undo this action'] = 'Il ne sera pas possible de revenir en arrire aprs cette action !';
$strings['Click to proceed'] = 'Cliquez pour excuter';
$strings['This version has already been upgraded to 1.0.0.'] = 'Cette version a dj t mise  jour en 1.0.0.';
$strings['Please delete this file.'] = 'Merci de dtruire ce fichier.';
$strings['Successful update'] = 'La mise  jour s\'est droule avec succs';
$strings['Patch completed successfully'] = 'Le correctif a t appliqu avec succs';
$strings['This will populate the required fields for phpScheduleIt 1.0.0 and patch a data bug in 0.9.9.'] = 'Cela va remplir les champs ncessaires   phpScheduleIt 1.0.0 and corriger un problme dans la 0.9.9.'
    . '<br />Il est seulement ncessaire d\'excuter ceci si vous procdez  une mise  jour manuelle d\' SQL ou que vous venez de 0.9.9';

// @since 1.0.0 RC1
$strings['If no value is specified, the default password set in the config file will be used.'] = 'Si aucune valeur n\'est prcise, le mot de passe par dfaut spcifi dans le fichier de configuration (config.php) sera utilis.';
$strings['Notify user that password has been changed?'] = 'L\'utilisateur doit il tre prvenu que son mot de passe a t chang ?';

// @since 1.1.0
$strings['This system requires that you have an email address.'] = 'Pour ce systme il est impratif que vous possdiez une adresse de messagerie lectronique';
$strings['Invalid User Name/Password.'] = 'Nom d\'utilisateur ou mot de passe invalide.';
$strings['Pending User Reservations'] = 'Rservations en cours pour l\' utilisateur';
$strings['Approve'] = 'Confirme';
$strings['Approve this reservation'] = 'Approuvez cette rservation';
$strings['Approve Reservations'] ='Approuvez ces rservations';

$strings['Announcement'] = 'Annonce';
$strings['Number'] = 'Nombre';
$strings['Add Announcement'] = 'Ajouter une Annonce';
$strings['Edit Announcement'] = 'modifier une Annonce';
$strings['All Announcements'] = 'Toutes les Annonces';
$strings['Delete Announcements'] = 'Supprimer une Annonce';
$strings['Use start date/time?'] = 'Utiliser date/heure de dbut ?';
$strings['Use end date/time?'] = 'Utiliser date/heure de fin?';
$strings['Announcement text is required.'] = 'Le texte de l\'annonce est ncessaire.';
$strings['Announcement number is required.'] = 'Le numro de l\'annonce est ncessaire.';

$strings['Pending Approval'] = 'Approbation en cours';
$strings['My reservation is approved'] = 'Ma rservation est approuve';
$strings['This reservation must be approved by the administrator.'] = 'Cette rservation doit tre approuve par l\'administrateur.';
$strings['Approval Required'] = 'Approbation ncessaire';
$strings['No reservations requiring approval'] = 'Aucune rservation ne ncessite d\'approbation.';
$strings['Your reservation was successfully approved'] = 'Votre rservation a t approuve.';
$strings['Reservation approved for'] = 'Reservation approuve pour %s';
$strings['approved'] = 'Approuve';
$strings['Reservation approved'] = 'Reservation approuve';

$strings['Valid username is required'] = 'Un nom d\'utlisateur valide est ncessaire.';
$strings['That logon name is taken already.'] = 'Cet identifiant de connexion est dj utilis.';
$strings['this will be your login'] = '(Ce sera votre identifiant de connexion.)';
$strings['Logon name'] = 'Identifiant de connexion';
$strings['Your logon name is'] = 'Votre identifiant de connexion est %s';

$strings['Start'] = 'Dbut';
$strings['End'] = 'Fin';
$strings['Start date must be less than or equal to end date'] = 'La date de dbut doit tre infrieure ou gale  la date de fin.';
$strings['That starting date has already passed'] = 'La date de dpart est d\'ores et dj passe.';
$strings['Basic'] = 'de base';
$strings['Participants'] = 'Participants';
$strings['Close'] = 'Fermer';
$strings['Start Date'] = 'Date de dbut';
$strings['End Date'] = 'Date de fin';
$strings['Minimum'] = 'Minimum';
$strings['Maximum'] = 'Maximum';
$strings['Allow Multiple Day Reservations'] = 'Permet des jours de rservation multiples';
$strings['Invited Users'] = 'Utilisateur invits';
$strings['Invite Users'] = 'Inviter des utilisateurs';
$strings['Remove Participants'] = 'Retirer des participants';
$strings['Reservation Invitation'] = 'Invitation  une rservation';
$strings['Manage Invites'] = 'Grer les invites';
$strings['No invite was selected'] = 'Aucun invit n\'a t slectionn';
$strings['reservation accepted'] = '%s  accepter votre invitation le %s';
$strings['reservation declined'] = '%s  dcliner votre invitation le %s';
$strings['Login to manage all of your invitiations'] = 'Connexion pour grer toutes vos invitations';
$strings['Reservation Participation Change'] = 'Modification de la participation  la rservation';
$strings['My Invitations'] = 'Mes invitations';
$strings['Accept'] = 'Accepter';
$strings['Decline'] = 'Dcliner';
$strings['Accept or decline this reservation'] = 'Accepter ou dcliner cette rservation';
$strings['My Reservation Participation'] = 'Ma participation  la rservation';
$strings['End Participation'] = 'Fin de participatioin';
$strings['Owner'] = 'Propritaire';
$strings['Particpating Users'] = 'Utilisateurs participants';
$strings['No advanced options available'] = 'Aucune option avance disponible';
$strings['Confirm reservation participation'] = 'Confirmez la participation  la rservation ';
$strings['Confirm'] = 'Confirmer';
$strings['Do for all reservations in the group?'] = 'Excution pour toutes les rservations de ce groupe ?';

$strings['My Calendar'] = 'Mon calendrier';
$strings['View My Calendar'] = 'Voir mon calendrier';
$strings['Participant'] = 'Participant';
$strings['Recurring'] = 'Rptitif';
$strings['Multiple Day'] = 'Jour multiple';
$strings['[today]'] = '[aujourd\'hui]';
$strings['Day View'] = 'Vue journalire';
$strings['Week View'] = 'Vue hebdomadaire';
$strings['Month View'] = 'Vue mensuelle';
$strings['Resource Calendar'] = 'Calendrier des ressources';
$strings['View Resource Calendar'] = 'Voir le calendrier des ressources';	// @since 1.2.0
$strings['Signup View'] = 'Vue des connexions';

$strings['Select User'] = 'Choisir un utilisateur';
$strings['Change'] = 'Modification';

$strings['Update'] = 'Mise  jour';
$strings['phpScheduleIt Update is only available for versions 1.0.0 or later'] = 'La mise  jour de phpScheduleIt n\'est disponible que pour les versions 1.0.0 et suivantes.';
$strings['phpScheduleIt is already up to date'] = 'phpScheduleIt est dj  jour';
$strings['Migrating reservations'] = 'Passage des rservations d\'une version  l\'autre.';

$strings['Admin'] = 'Administrateur';
$strings['Manage Announcements'] = 'Gestion des annonces';
$strings['There are no announcements'] = 'Il n\'y a pas d\'annonce';
// end since 1.1.0

// @since 1.2.0
$strings['Maximum Participant Capacity'] = 'Nombre maximum de participants';
$strings['Leave blank for unlimited'] ='Laisser blanc pour illimit';
$strings['Maximum of participants'] = 'Cette ressource  une capacit maximum de %s participants';
$strings['That reservation is at full capacity.'] = 'Cette reservation est complte.';
$strings['Allow registered users to join?'] = 'Permettre au utilisateurs enregistrs de se joindre?';
$strings['Allow non-registered users to join?'] = 'Permettre au utilisateurs non enregistrs de se joindre?';
$strings['Join'] = 'Rejoindre';
$strings['My Participation Options'] = 'Mes options de participation';
$strings['Join Reservation'] = 'Joindre la rservation';
$strings['Join All Recurring'] = 'Joindre tout les rcurrences';
$strings['You are not participating on the following reservation dates because they are at full capacity.'] = 'Vous ne participez pas aux reservations  ces dates parcequ\'elles sont compltes.';
$strings['You are already invited to this reservation. Please follow participation instructions previously sent to your email.'] = 'Vous tes dj invited pour cette reservation. Veuillez suivre les instructions qui vous ont ts envoys dans l\'email de participation.';
$strings['Additional Tools'] = 'Outils additionnels';
$strings['Create User'] = 'Crer un utilisateur';
$strings['Check Availability'] = 'Vrifier la disponibilit';
$strings['Manage Additional Resources'] = 'Grer les accessoires';
$strings['Number Available'] = 'Nombre disponible';
$strings['Unlimited'] = 'Illimit';
$strings['Add Additional Resource'] = 'Ajouter l\'accessoire';
$strings['Edit Additional Resource'] = 'Editer l\'accessoire';
$strings['Checking'] = 'Vrifier';
$strings['You did not select anything to delete.'] = 'Vous n\'avez rien  slectionn pour l\'effacement.';
$strings['Added Resources'] = 'Ressources ajoutes';
$strings['Additional resource is reserved'] = 'The additional resource %s only has %s available at a time';
$strings['All Groups'] = 'Tout les groupes';
$strings['Group Name'] = 'Nom du groupe';
$strings['Delete Groups'] = 'Effacer les groupes';
$strings['Manage Groups'] = 'Grer les groupes';
$strings['None'] = 'Aucun';
$strings['Group name is required.'] = 'Le nom du groupe est ncessaire.';
$strings['Groups'] = 'Groupes';
$strings['Current Groups'] = 'Groupes actuels';
$strings['Group Administration'] = 'Administration du groupe';
$strings['Reminder Subject'] = 'Rappel de rservation- %s, %s %s';
$strings['Reminder'] = 'Rappel';
$strings['before reservation'] = 'avant la reservation';
$strings['My Participation'] = 'Ma Participation';
$strings['My Past Participation'] = 'Mes participations passe';
$strings['Timezone'] = 'Fuseau horaire';
$strings['Export'] = 'Exportation';
$strings['Select reservations to export'] = 'Selectionner les reservations  exporter';
$strings['Export Format'] = 'Format d\'exportation';
$strings['This resource cannot be reserved less than x hours in advance'] = 'Cette resource ne peut pas tre moins de %s heures  l\'avance';
$strings['This resource cannot be reserved more than x hours in advance'] = 'Cette resource ne peut pas tre rserve plus de %s heures  l\'avance';
$strings['Minimum Booking Notice'] = 'Notification minimum de rservation';
$strings['Maximum Booking Notice'] = 'Notification maximum de rservation';
$strings['hours prior to the start time'] = 'heures avant l\'heure de dbut';
$strings['hours from the current time'] = 'heures  partir de l\'heure actuelle';
$strings['Contains'] = 'Contient';
$strings['Begins with'] = 'Commence avec';
$strings['Minimum booking notice is required.'] = 'L\'avertissement si la rservation est presque vide est obligatoire.';
$strings['Maximum booking notice is required.'] = 'L\'avertissement si la rservation est complte est obligatoire.';
$strings['Accessory Name'] = 'Nom de l\'accessoire';
$strings['Accessories'] = 'Accessoires';
$strings['All Accessories'] = 'Tout les accessoires';
$strings['Added Accessories'] = 'Accessoires rajouts';
$strings['Bookings'] = 'Rservations';
// end since 1.2.0

/***
  EMAIL MESSAGES
  Please translate these email messages into your language.  You should keep the sprintf (%s) placeholders
   in their current position unless you know you need to move them.
  All email messages should be surrounded by double quotes "
  Each email message will be described below.
***/
// @since 1.1.0
// Email message that a user gets after they register
$email['register'] = "%s, %s \r\n"
        . "Vous avez t correctement enregistr avec les informations suivantes :\r\n"
        . "Identifiant : %s\r\n"
        . "Nom : %s %s \r\n"
        . "Tlphone : %s \r\n"
        . "Socit : %s \r\n"
        . "Position : %s \r\n\r\n"
        . "Merci de vous connecter au planificateur  cet emplacement :\r\n"
        . "%s \r\n\r\n"
        . "Vous trouverez des liens hypertexte pour accder au planificateur en ligne et  Mon Panneau de Contrle.\r\n\r\n"
        . "Merci d\'adresser toutes questions concernant les ressources ou les rservations  %s";

// Email message the admin gets after a new user registers
$email['register_admin'] = "Administrateur,\r\n\r\n"
          . "Un nouvel utilisateur a t ajout avec les informations :\r\n"
          . "Adresse de messagerie : %s\r\n"
          . "Nom : %s %s\r\n"
          . "Tlphone : %s\r\n"
          . "Socit : %s\r\n"
          . "Position : %s\r\n\r\n";

// First part of the email that a user gets after they create/modify/delete a reservation
// 'reservation_activity_1' through 'reservation_activity_6' are all part of one email message
//  that needs to be assembled depending on different options.  Please translate all of them.
// @since 1.1.0
$email['reservation_activity_1'] = "%s,\r\n<br />"
      . "Vous avez rserv %s numro de rservation #%s avec succs.\r\n\r\n<br/><br/>"
      . "Merci d\'utiliser ce numro de rservation lors de toute question  l\'administrateur.\r\n\r\n<br/><br/>"
      . "Une rservation entre %s %s et %s %s pour %s"
      . " situe  %s a t %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_2'] = "Cette rservation a t rpte pour les dates suivantes :\r\n<br/>";
$email['reservation_activity_3'] = "Toutes les reservations cycliques de ce groupe sont aussi %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_4'] = "Le rsum suivant a t tabli pour la rservation suivante :\r\n<br/>%s\r\n\r\n<br/><br/>";
$email['reservation_activity_5'] = "S'il s'agissait d'une erreur, merci de contacter l'administrateur  : %s"
      . " ou en appelant le %s.\r\n\r\n<br/><br/>"
      . "Vous pouvez voir et/ou modifier les informations relatives  vos rservation  tout moment en "
      . " vous connectant %s  :\r\n<br/>"
      . "<a href=\"%s\" target=\"_blank\">%s</a>.\r\n\r\n<br/><br/>";
$email['reservation_activity_6'] = "Merci d'adresser toutes questions techniques  <a href=\"mailto:%s\">%s</a>.\r\n\r\n<br/><br/>";
// @since 1.1.0
$email['reservation_activity_7'] = "%s,\r\n<br />"
      . "La rservation  #%s a t confirme.\r\n\r\n<br/><br/>"
      . "Merci d\'utiliser ce numro de rservation lors de toute question  l\'administrateur.\r\n\r\n<br/><br/>"
      . "Une rservation entre %s %s et %s %s pour %s"
      . " situe  %s a t %s.\r\n\r\n<br/><br/>";

// Email that the user gets when the administrator changes their password
$email['password_reset'] = "Votre mot de passe %s a t r-initialis par l'administrateur.\r\n\r\n"
      . "Votre mot de passe temporaire est :\r\n\r\n %s\r\n\r\n"
      . "Merci d'utiliser ce mot de passe temporaire (faire copier/coller afin d'tre sr qu'il soit correct) pour vous connecter %s au %s"
      . " ,changez le immediatement en utilisant 'Modifier les informations de mon profil/mot de passe' situ dans la table Mes liens rapides.\r\n\r\n"
      . "Merci de contacter %s pour toutes questions.";

// Email that the user gets when they change their lost password using the 'Password Reset' form
$email['new_password'] = "%s,\r\n"
            . "Votre nouveau mot de passe pour votre compte %s est :\r\n\r\n"
            . "%s\r\n\r\n"
            . "Merci de vous connecter  %s "
            . "avec ce nouveau mot de passe "
            . "(faire copier/coller afin d'tre sr qu'il soit correct) "
            . "et changer le rapidement en clickant sur "
            . "Modifier les informations de mon profil/mot de passe "
            . "situ dans mon panneau de contrle.\r\n\r\n"
            . "Merci d'adresser toutes questions  %s.";

// @since 1.1.0
// Email that is sent to invite users to a reservation
$email['reservation_invite'] = "%s vous a invit  participer  la rservation suivante :\r\n\r\n"
    . "Resource : %s\r\n"
    . "Date de dbut : %s\r\n"
    . "Heure de dbut : %s\r\n"
    . "Date de fin : %s\r\n"
    . "Heure de fin : %s\r\n"
    . "Rsum : %s\r\n"
    . "Dates rptitives (s\'il y en a): %s\r\n\r\n"
    . "Pour accepter cette invitation cliquer sur ce lien (faire un copier/coller s\'il n\'est pas actif) %s\r\n"
    . "Pour dcliner cette invitation cliquer sur ce lien (faire un copier/coller s\'il n\'est pas actif) %s\r\n"
    . "Pour accepter choisir des dats ou grez vos invitations ultrieurement, merci de vous connecter  %s  %s";

// @since 1.1.0
// Email that is sent when a user is removed from a reservation
$email['reservation_removal'] = "Vous avez t retir de la rservation suivante :\r\n\r\n"
    . "Resource : %s\r\n"
    . "Date de dbut : %s\r\n"
    . "Heure de dbut : %s\r\n"
    . "Date de fin : %s\r\n"
    . "Heure de fin : %s\r\n"
    . "Rsum : %s\r\n"
    . "Dates rptitives (s\'il y en a): %s\r\n\r\n";

// @since 1.2.0
// Email body that is sent for reminders
$email['Reminder Body'] = "Votre reservation pour %s de %s %s  %s %s se rapproche.";
?>
