<?php
/**
* Polish (en) translation file.
* This also serves as the base translation file from which to derive
*  all other translations.
*  
* @author Arkadiusz Lipiec arkadiusz.lipiec@gmail.com
* @version 05-11-09
* @package Languages
*
* Copyright (C) 2003 - 2007 phpScheduleIt
* License: GPL, see LICENSE
*/
///////////////////////////////////////////////////////////
// INSTRUCTIONS
///////////////////////////////////////////////////////////
// This file contains all of the strings that are used throughout phpScheduleit.
// Please save the translated file as '2 letter language code'.lang.php.  For example, en.lang.php.
// 
// To make phpScheduleIt available in another language, simply translate each
//  of the following strings into the appropriate one for the language.  If there
//  is no direct translation, please provide the closest translation.  Please be sure
//  to make the proper additions the /config/langs.php file (instructions are in the file).
//  Also, please add a help translation for your language using en.help.php as a base.
//
// You will probably keep all sprintf (%s) tags in their current place.  These tags
//  are there as a substitution placeholder.  Please check the output after translating
//  to be sure that the sentences make sense.
//
// + Please use single quotes ' around all $strings.  If you need to use the ' character, please enter it as \'
// + Please use double quotes " around all $email.  If you need to use the " character, please enter it as \"
//
// + For all $dates please use the PHP strftime() syntax
//    http://us2.php.net/manual/en/function.strftime.php
//
// + Non-intuitive parts of this file will be explained with comments.  If you
//    have any questions, please email lqqkout13@users.sourceforge.net
//    or post questions in the Developers forum on SourceForge
//    http://sourceforge.net/forum/forum.php?forum_id=331297
///////////////////////////////////////////////////////////

////////////////////////////////
/* Do not modify this section */
////////////////////////////////
global $strings;			  //
global $email;				  //
global $dates;				  //
global $charset;			  //
global $letters;			  //
global $days_full;			  //
global $days_abbr;			  //
global $days_two;			  //
global $days_letter;		  //
global $months_full;		  //
global $months_abbr;		  //
global $days_letter;		  //
/******************************/

// Charset for this language
// 'iso-8859-1' will work for most languages
$charset = 'windows-1250';

/***
  DAY NAMES
  All of these arrays MUST start with Sunday as the first element 
   and go through the seven day week, ending on Saturday
***/
// The full day name
$days_full = array('Niedziela', 'Poniedziaek', 'Wtorek', 'roda', 'Czwartek', 'Pitek', 'Sobota');
// The three letter abbreviation
$days_abbr = array('Nie', 'Pon', 'Wto', 'ro', 'Czw', 'Pt', 'Sob');
// The two letter abbreviation
$days_two  = array('Ni', 'Po', 'Wt', 'r', 'Cz', 'Pt', 'So');
// The one letter abbreviation
$days_letter = array('N', 'P', 'W', '', 'C', 'P', 'S');

/***
  MONTH NAMES
  All of these arrays MUST start with January as the first element
   and go through the twelve months of the year, ending on December
***/
// The full month name
$months_full = array('Stycze', 'Luty', 'Marzec', 'Kwiecie', 'Maj', 'Czerwiec', 'Lipiec', 'Sierpie', 'Wrzesie', 'Padziernik', 'Listopad', 'Grudzie');
// The three letter month name
$months_abbr = array('Sty', 'Lut', 'Mar', 'Kwi', 'Maj', 'Cze', 'Lip', 'Sie', 'Wrz', 'Pa', 'Lis', 'Gru');

// All letters of the alphabet starting with A and ending with Z
$letters = array ('A', '', 'B', 'C', '', 'D', 'E', '', 'F', 'G', 'H', 'I', 'J', 'K', 'L', '', 'M', 'N', '', 'O', '', 'P', 'Q', 'R', 'S', '', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '', '');

/***
  DATE FORMATTING
  All of the date formatting must use the PHP strftime() syntax
  You can include any text/HTML formatting in the translation
***/
// General date formatting used for all date display unless otherwise noted
$dates['general_date'] = '%d/%m/%Y';
// General datetime formatting used for all datetime display unless otherwise noted
// The hour:minute:second will always follow this format
$dates['general_datetime'] = '%d/%m/%Y @';
// Date in the reservation notification popup and email
$dates['res_check'] = '%A %d/%m/%Y';
// Date on the scheduler that appears above the resource links
$dates['schedule_daily'] = '%A,<br/>%d/%m/%Y';
// Date on top-right of each page
$dates['header'] = '%A, %B %d, %Y';
// Jump box format on bottom of the schedule page
// This must only include %m %d %Y in the proper order,
//  other specifiers will be ignored and will corrupt the jump box 
$dates['jumpbox'] = '%d %m %Y';

/***
  STRING TRANSLATIONS
  All of these strings should be translated from the English value (right side of the equals sign) to the new language.
  - Please keep the keys (between the [] brackets) as they are.  The keys will not always be the same as the value.
  - Please keep the sprintf formatting (%s) placeholders where they are unless you are sure it needs to be moved.
  - Please keep the HTML and punctuation as-is unless you know that you want to change it.
***/
$strings['hours'] = 'godzin(y)';
$strings['minutes'] = 'minut(y)';
// The common abbreviation to hint that a user should enter the month as 2 digits
$strings['mm'] = 'mm';
// The common abbreviation to hint that a user should enter the day as 2 digits
$strings['dd'] = 'dd';
// The common abbreviation to hint that a user should enter the year as 4 digits
$strings['yyyy'] = 'rrrr';
$strings['am'] = 'am';
$strings['pm'] = 'pm';

$strings['Administrator'] = 'Administrator';
$strings['Welcome Back'] = 'Witaj znowu, %s';
$strings['Log Out'] = 'Wyloguj';
$strings['My Control Panel'] = 'Panel sterowania';
$strings['Help'] = 'Pomoc';
$strings['Manage Schedules'] = 'Terminy';
$strings['Manage Users'] ='Uytkownicy';
$strings['Manage Resources'] ='Zasoby';
$strings['Manage User Training'] ='Szkolenie uytkownikw';
$strings['Manage Reservations'] ='Rezerwacje';
$strings['Email Users'] ='Email do uytkownikw';
$strings['Export Database Data'] = 'Eksport danych z bazy';
$strings['Reset Password'] = 'Wyzeruj haso';
$strings['System Administration'] = 'Administracja systemem';
$strings['Successful update'] = 'Aktualizacja powioda si';
$strings['Update failed!'] = 'Aktualizacja zakoczona niepowodzeniem!';
$strings['Manage Blackout Times'] = 'Czasy niedostpnoci';
$strings['Forgot Password'] = 'Zapomniaem hasa';
$strings['Manage My Email Contacts'] = 'Zarzdzaj kontaktami email';
$strings['Choose Date'] = 'Wybierz dat';
$strings['Modify My Profile'] = 'Modyfikacja profilu';
$strings['Register'] = 'Zarejestruj';
$strings['Processing Blackout'] = 'Przetwarzanie terminw niedostpnoci';
$strings['Processing Reservation'] = 'Przetwarzanie rezerwacji';
$strings['Online Scheduler [Read-only Mode]'] = 'Terminarz online [tylko do odczytu]';
$strings['Online Scheduler'] = 'Terminarz online';
$strings['phpScheduleIt Statistics'] = 'Statystyki phpScheduleIt';
$strings['User Info'] = 'Informacje o uytkowniku:';

$strings['Could not determine tool'] = 'Nie mona znale narzdzia. Wr do panelu administracyjnego i sprbuj ponownie.';
$strings['This is only accessable to the administrator'] = 'Ta opcja jest dostpna tylko dla administratora';
$strings['Back to My Control Panel'] = 'Powrt do panelu administracyjnego';
$strings['That schedule is not available.'] = 'Ten termin nie jest dostpny.';
$strings['You did not select any schedules to delete.'] = 'Nie wybrano terminw do usunicia.';
$strings['You did not select any members to delete.'] = 'Nie wybrano uytkownikw do usunicia.';
$strings['You did not select any resources to delete.'] = 'Nie wybrano adnych zasobw do usunicia.';
$strings['Schedule title is required.'] = 'Wymagany jest tytu terminu.';
$strings['Invalid start/end times'] = 'Niepoprawna data pocztkowa/kocowa.';
$strings['View days is required'] = 'Wymagane jest pole wywieltlanych dni';
$strings['Day offset is required'] = 'Wymagane jest stworzenie odcinkw czasu';
$strings['Admin email is required'] = 'Wymagany jest adres email administratora';
$strings['Resource name is required.'] = 'Wymagana jest nazwa zasobu.';
$strings['Valid schedule must be selected'] = 'Naley wybra poprawny termin';
$strings['Minimum reservation length must be less than or equal to maximum reservation length.'] = 'Miminalna dugo rezerwacji musi by mniejsza lub co najmniej rwna maksymalnej.';
$strings['Your request was processed successfully.'] = 'Twoje danie zostao pomylnie przetworzone.';
$strings['Go back to system administration'] = 'Powrt do administracji systemem';
$strings['Or wait to be automatically redirected there.'] = 'Lub poczekaj na automatyczne przekierowanie.';
$strings['There were problems processing your request.'] = 'Wystpi problem z przetworzeniem dania.';
$strings['Please go back and correct any errors.'] = 'Wr i popraw wszystkie bdy.';
$strings['Login to view details and place reservations'] = 'Zaloguj si aby zobaczy szczegy oraz zarezerwowa termin';
$strings['Memberid is not available.'] = 'Memberid: %s nie jest dostpny.';

$strings['Schedule Title'] = 'Nazwa terminu';
$strings['Start Time'] = 'Czas rozpoczcia';
$strings['End Time'] = 'Czas zakoczenia';
$strings['Time Span'] = 'Odcinki czasu';
$strings['Weekday Start'] = 'Pierwszy dzie tygodnia';
$strings['Admin Email'] = 'Email administratora';

$strings['Default'] = 'Domylny';
$strings['Reset'] = 'Wyczy';
$strings['Edit'] = 'Edycja';
$strings['Delete'] = 'Usu';
$strings['Cancel'] = 'Anuluj';
$strings['View'] = 'Wywietl';
$strings['Modify'] = 'Zmie';
$strings['Save'] = 'Zapisz';
$strings['Back'] = 'Powrt';
$strings['Next'] = 'Dalej';
$strings['Close Window'] = 'Zamknij okno';
$strings['Search'] = 'Wyszukaj';
$strings['Clear'] = 'Wyczy';

$strings['Days to Show'] = 'Wywieltane dni';
$strings['Reservation Offset'] = 'Margines czasu rezerwacji';
$strings['Hidden'] = 'Ukryty';
$strings['Show Summary'] = 'Wywietlanie informacji';
$strings['Add Schedule'] = 'Dodaj termin';
$strings['Edit Schedule'] = 'Zmodyfikuj termin';
$strings['No'] = 'Nie';
$strings['Yes'] = 'Tak';
$strings['Name'] = 'Nazwa';
$strings['First Name'] = 'Imi';
$strings['Last Name'] = 'Nazwisko';
$strings['Resource Name'] = 'Nazwa zasobu';
$strings['Email'] = 'Email';
$strings['Institution'] = 'Instytucja';
$strings['Phone'] = 'Telefon';
$strings['Password'] = 'Haso';
$strings['Permissions'] = 'Uprawnienia';
$strings['View information about'] = 'Wywietl informacje o %s %s';
$strings['Send email to'] = 'Wylij maila do %s %s';
$strings['Reset password for'] = 'Wyzeruj haso dla %s %s';
$strings['Edit permissions for'] = 'Zmodyfikuj uprawnienia dla %s %s';
$strings['Position'] = 'Pozycja';
$strings['Password (6 char min)'] = 'Haso (%s min znakw)';	// @since 1.1.0
$strings['Re-Enter Password'] = 'Powtrz haso';

$strings['Sort by descending last name'] = 'Sortowanie malejce po nazwisku';
$strings['Sort by descending email address'] = 'Sortowanie malejce po adresie email';
$strings['Sort by descending institution'] = 'Sortowanie malejce po instytucji';
$strings['Sort by ascending last name'] = 'Sortowanie rosnce po nazwisku';
$strings['Sort by ascending email address'] = 'Sortowanie rosnce po adresie email';
$strings['Sort by ascending institution'] = 'Sortowanie rosnco po instytucji';
$strings['Sort by descending resource name'] = 'Sortowanie malejco po nazwie zasobu';
$strings['Sort by descending location'] = 'Sortowanie malejco po lokalizacji';
$strings['Sort by descending schedule title'] = 'Sortowanie malejco po tytule terminu';
$strings['Sort by ascending resource name'] = 'Sortowanie rosnco po nazwie zasobu';
$strings['Sort by ascending location'] = 'Sortowanie rosnco po lokalizacji';
$strings['Sort by ascending schedule title'] = 'Sortowanie rosnco po tytule terminu';
$strings['Sort by descending date'] = 'Sortowanie malejco po dacie';
$strings['Sort by descending user name'] = 'Sortowanie malejco po nazwie uytkownika';
$strings['Sort by descending start time'] = 'Sortowanie malejco po czasie rozpoczcia';
$strings['Sort by descending end time'] = 'Sortowanie malejco po czasie zakoczenia';
$strings['Sort by ascending date'] = 'Sortowanie rosnco po dacie';
$strings['Sort by ascending user name'] = 'Sortowanie rosnco po nazwie uytkownika';
$strings['Sort by ascending start time'] = 'Sortowanie rosnco po czasie rozpoczcia';
$strings['Sort by ascending end time'] = 'Sortowanie rosnco po czasie zakoczenia';
$strings['Sort by descending created time'] = 'Sortowanie malejco po czasie utworzenia';
$strings['Sort by ascending created time'] = 'Sortowanie rosnco po czasie utworzenia';
$strings['Sort by descending last modified time'] = 'Sortowanie malejco po czasie ostatniej modyfikacji';
$strings['Sort by ascending last modified time'] = 'Sortowanie rosnco po czasie ostatniej modyfikacji';

$strings['Search Users'] = 'Wyszukaj uytkownikw';
$strings['Location'] = 'Lokalizacja';
$strings['Schedule'] = 'Termin';
$strings['Phone'] = 'Telefon';
$strings['Notes'] = 'Uwagi';
$strings['Status'] = 'Status';
$strings['All Schedules'] = 'Wszystkie terminy';
$strings['All Resources'] = 'Wszystkie zasoby';
$strings['All Users'] = 'Wszyscy uytkownicy';

$strings['Edit data for'] = 'Zmodyfikuj dane dla %s';
$strings['Active'] = 'Aktywny';
$strings['Inactive'] = 'Nieaktywny';
$strings['Toggle this resource active/inactive'] = 'Przecz ten zasb na aktywny/nieaktywny';
$strings['Minimum Reservation Time'] = 'Minimalny czas rezerwacji';
$strings['Maximum Reservation Time'] = 'Maksymalny czas rezerwacji';
$strings['Auto-assign permission'] = 'Automatyczny przydzia uprawnie';
$strings['Add Resource'] = 'Dodaj zasb';
$strings['Edit Resource'] = 'Zmodyfikuj zasb';
$strings['Allowed'] = 'Dostpne';
$strings['Notify user'] = 'Powiadom uytkownika';
$strings['User Reservations'] = 'Rezerwacje uytkownika';
$strings['Date'] = 'Data';
$strings['User'] = 'Uytkownik';
$strings['Email Users'] = 'Wylij maila uytkownikom';
$strings['Subject'] = 'Temat';
$strings['Message'] = 'Wiadomo';
$strings['Please select users'] = 'Wybierz uytkownikw';
$strings['Send Email'] = 'Wylij email';
$strings['problem sending email'] = 'Niestety, nie udao si wysa emaila. Sprbuj jeszcze raz pniej.';
$strings['The email sent successfully.'] = 'Wysano pomylnie emaila.';
$strings['do not refresh page'] = 'Prosz <u>nie odwiea</u> tej strony. Ta akcja spowoduje ponowne wysanie emaila.';
$strings['Return to email management'] = 'Wr do zarzdzania emailami';
$strings['Please select which tables and fields to export'] = 'Wybierz ktre tabele i ktre pola maj zosta wyekportowane:';
$strings['all fields'] = '- wszystkie pola -';
$strings['HTML'] = 'HTML';
$strings['Plain text'] = 'Zwyky tekst';
$strings['XML'] = 'XML';
$strings['CSV'] = 'CSV';
$strings['Export Data'] = 'Export Data';
$strings['Reset Password for'] = 'Wyzeruj haso dla %s';
$strings['Please edit your profile'] = 'Prosz zmodyfikowa swj profil';
$strings['Please register'] = 'Zarejestruj si';
$strings['Keep me logged in'] = 'Utrzymuj sesj <br/>(wymaga cookie)';
$strings['Edit Profile'] = 'Edycja profilu';
$strings['Register'] = 'Rejestracja';
$strings['Please Log In'] = 'Prosz si zalogowa';
$strings['Email address'] = 'Adres email';
$strings['Password'] = 'Haso';
$strings['First time user'] = 'Jeste tu pierwszy raz?';
$strings['Click here to register'] = '<br>Kliknij tu aby si zarejestrowa';
$strings['Register for phpScheduleIt'] = 'Zarejestruj w systemie';
$strings['Log In'] = 'Zaloguj';
$strings['View Schedule'] = 'Zobacz terminy';
$strings['View a read-only version of the schedule'] = 'Wywietl wersj terminarza tylko do odczytu';
$strings['I Forgot My Password'] = 'Zapomniaem hasa';
$strings['Retreive lost password'] = 'Przywr utracone haso';
$strings['Get online help'] = 'Pomoc internetowa';
$strings['Language'] = 'Jzyk';
$strings['(Default)'] = '(Domylny)';

$strings['My Announcements'] = 'Moje powiadomienia';
$strings['My Reservations'] = 'Moje rezerwacje';
$strings['My Permissions'] = 'Uprawnienia';
$strings['My Quick Links'] = 'Odnoniki';
$strings['Announcements as of'] = 'Powiadomienia do dnia %s';
$strings['There are no announcements.'] = 'Brak powiadomie.';
$strings['Resource'] = 'Zasb';
$strings['Created'] = 'Utworzono';
$strings['Last Modified'] = 'Ost. modyfikacja';
$strings['View this reservation'] = 'Wywietl t rezerwacj';
$strings['Modify this reservation'] = 'Zmie t rezerwacj';
$strings['Delete this reservation'] = 'Usu t rezerwacj';
$strings['Bookings'] = 'Rezerwacje';										// @since 1.2.0
$strings['Change My Profile Information/Password'] = 'Edycja profilu';		// @since 1.2.0
$strings['Manage My Email Preferences'] = 'Ustawienia email';				// @since 1.2.0
$strings['Mass Email Users'] = 'Masowa wysyka maili';
$strings['Search Scheduled Resource Usage'] = 'Wyszukaj rezerwacje';		// @since 1.2.0
$strings['Export Database Content'] = 'Wyeksportuj zawarto bazy danych';
$strings['View System Stats'] = 'Statystyki systemu';
$strings['Email Administrator'] = 'Email do administratora';

$strings['Email me when'] = 'Wylij emaila gdy:';
$strings['I place a reservation'] = 'Utworzona zostanie nowa rezerwacja';
$strings['My reservation is modified'] = 'Moja rezerwacja zostanie zmieniona';
$strings['My reservation is deleted'] = 'Moja rezerwacja zostanie usunita';
$strings['I prefer'] = 'Format wiadomoci:';
$strings['Your email preferences were successfully saved'] = 'Twoje ustawienia email zostay pomylnie zapisane!';
$strings['Return to My Control Panel'] = 'Powrt do panelu sterowania';

$strings['Please select the starting and ending times'] = 'Wybierz czas rozpoczcia i zakoczenia:';
$strings['Please change the starting and ending times'] = 'Zmie czas rozpoczcia i zakoczenia:';
$strings['Reserved time'] = 'Czas rezerwacji:';
$strings['Minimum Reservation Length'] = 'Minimalna dugo rezerwacji:';
$strings['Maximum Reservation Length'] = 'Maksymalna dugo rezerwacji:';
$strings['Reserved for'] = 'Rezerwacja dla:';
$strings['Will be reserved for'] = 'Bdzie zarezerwowany dla:';
$strings['N/A'] = 'N/A';
$strings['Update all recurring records in group'] = 'Uaktualni wszystkie powizane rekordy w grupie?';
$strings['Delete?'] = 'Usun?';
$strings['Never'] = '-- Nigdy --';
$strings['Days'] = 'Dni';
$strings['Weeks'] = 'Tygodnie';
$strings['Months (date)'] = 'Miesice (data)';
$strings['Months (day)'] = 'Miesice (dzie)';
$strings['First Days'] = 'Pierwsze dni';
$strings['Second Days'] = 'Drugie dni';
$strings['Third Days'] = 'Trzecie dni';
$strings['Fourth Days'] = 'Czwarte dni';
$strings['Last Days'] = 'Ostatnie dni';
$strings['Repeat every'] = 'Powtarzaj co:';
$strings['Repeat on'] = 'Powtarzaj od:';
$strings['Repeat until date'] = 'Powtarzaj do daty:';
$strings['Choose Date'] = 'Wybierz dat';
$strings['Summary'] = 'Informacje';

$strings['View schedule'] = 'Widok terminw:';
$strings['My Reservations'] = 'Moje rezerwacje';
$strings['My Past Reservations'] = 'Moje przesze rezerwacje';
$strings['Other Reservations'] = 'Inne rezerwacje';
$strings['Other Past Reservations'] = 'Inne przesze rezerwacje';
$strings['Blacked Out Time'] = 'Czas niedostpnoci';
$strings['Set blackout times'] = 'Ustaw czas niedostpnoci dla %s na %s'; 
$strings['Reserve on'] = 'Zarezerwuj %s na %s';
$strings['Prev Week'] = '&laquo; Pop. tydzie';
$strings['Jump 1 week back'] = 'Skocz 1 tydzie wstecz';
$strings['Prev days'] = '&#8249; Poprz. %d dni';
$strings['Previous days'] = '&#8249; Poprz. %d dni';
$strings['This Week'] = 'Ten tydzie';
$strings['Jump to this week'] = 'Skocz do tego tygodnia';
$strings['Next days'] = 'Nast. %d dni &#8250;';
$strings['Next Week'] = 'Nast. tydzie &raquo;';
$strings['Jump To Date'] = 'Skocz do daty';
$strings['View Monthly Calendar'] = 'Obejrzyj miesiczny kalendarz';
$strings['Open up a navigational calendar'] = 'Otwrz kalendarz nawigacyjny';

$strings['View stats for schedule'] = 'Zobacz statystyki dla terminu:';
$strings['At A Glance'] = 'Przegld';
$strings['Total Users'] = 'Wszyscy uytkownicy:';
$strings['Total Resources'] = 'Wszystkie zasoby:';
$strings['Total Reservations'] = 'Cakowite rezerwacje:';
$strings['Max Reservation'] = 'Maksymalna rezerwacja:';
$strings['Min Reservation'] = 'Najkrtsza rezerwacja:';
$strings['Avg Reservation'] = 'rednia rezerwacja:';
$strings['Most Active Resource'] = 'Najaktywniejszy zasb:';
$strings['Most Active User'] = 'Najaktywniejszy uytkownik:';
$strings['System Stats'] = 'Statystyki systemu';
$strings['phpScheduleIt version'] = 'Wersja phpScheduleIt:';
$strings['Database backend'] = 'Proces ta bazy danych:';
$strings['Database name'] = 'Nazwa bazy danych:';
$strings['PHP version'] = 'Wersja PHP:';
$strings['Server OS'] = 'System OS serwera:';
$strings['Server name'] = 'Nazwa serwera:';
$strings['phpScheduleIt root directory'] = 'Katalog gwny phpScheduleIt:';
$strings['Using permissions'] = 'Uywanie uprawnie:';
$strings['Using logging'] = 'Uywanie dziennika:';
$strings['Log file'] = 'Pik dziennika:';
$strings['Admin email address'] = 'Administracyjne adresy email:';
$strings['Tech email address'] = 'Techniczne adresy email:';
$strings['CC email addresses'] = 'Adresy email CC:';
$strings['Reservation start time'] = 'Pocztek rezerwacji:';
$strings['Reservation end time'] = 'Koniec rezerwacji:';
$strings['Days shown at a time'] = 'Days shown at a time:';
$strings['Reservations'] = 'Rezerwacje';
$strings['Return to top'] = 'Powrt do gry';
$strings['for'] = 'dla';

$strings['Select Search Criteria'] = 'Wybierz kryteria wyszukiwania';
$strings['Schedules'] = 'Terminy:';
$strings['All Schedules'] = 'Wszystkie terminy';
$strings['Hold CTRL to select multiple'] = 'Przytrzymaj CTRL aby wybra wiele pozycji';
$strings['Users'] = 'Uytkownicy:';
$strings['All Users'] = 'Wszyscy uytkownicy';
$strings['Resources'] = 'Zasoby';		// @since 1.2.0
$strings['All Resources'] = 'Wszystkie zasoby';
$strings['Starting Date'] = 'Data pocztkowa:';
$strings['Ending Date'] = 'Data kocowa:';
$strings['Starting Time'] = 'Czas pocztkowy:';
$strings['Ending Time'] = 'Czas kocowy:';
$strings['Output Type'] = 'Typ wyjcia:';
$strings['Manage'] = 'Zarzdzaj';
$strings['Total Time'] = 'Cakowity czas';
$strings['Total hours'] = 'W sumie godzin:';
$strings['% of total resource time'] = '% cakowitego czasu zasobw';
$strings['View these results as'] = 'Przejrzyj wyniki jako:';
$strings['Edit this reservation'] = 'Zmodyfikuj t rezerwacj';
$strings['Search Results'] = 'Rezultaty wyszukiwania';
$strings['Search Resource Usage'] = 'Uycie wyszkukiwarki';
$strings['Search Results found'] = 'Wyniki wyszukiwania: znaleziono %d rezerwacji';
$strings['Try a different search'] = 'Sprbuj wyszuka z innymi warunkami';
$strings['Search Run On'] = 'Wyszukiwanie na:';
$strings['Member ID'] = 'ID uytkownika';
$strings['Previous User'] = '&laquo; Poprzedni uytkownik';
$strings['Next User'] = 'Nastpny uytkownik &raquo;';

$strings['No results'] = 'No results';
$strings['That record could not be found.'] = 'Noe mona znale tego rekordu.';
$strings['This blackout is not recurring.'] = 'Ten czas niedostpnoci si nie powtarza.';
$strings['This reservation is not recurring.'] = 'Ta rezerwacja si nie powtarza.';
$strings['There are no records in the table.'] = 'Brak rekordw w tabeli %s.';
$strings['You do not have any reservations scheduled.'] = 'Nie masz adnych zaplanowanych rezerwacji.';
$strings['You do not have permission to use any resources.'] = 'Nie masz uprawnie aby uywa jakichkolwiek zasobw.';
$strings['No resources in the database.'] = 'Brak zasobw w bazie danych.';
$strings['There was an error executing your query'] = 'Wystpi bd przy przetwarzaniu polecenia:';

$strings['That cookie seems to be invalid'] = 'Ten plik cookie nie wyglda na prawidowy';
$strings['We could not find that logon in our database.'] = 'Nie mona znale tego loginu w bazie danych.';	// @since 1.1.0
$strings['That password did not match the one in our database.'] = 'To haso nie zgadza si z hasem z bazy danych.';
$strings['You can try'] = '<br />Sprbuj:<br />Zarejestrowa adres email.<br />Or:<br />Ponowi prb logowania.';
$strings['A new user has been added'] = 'Dodano nowego uytkownika';
$strings['You have successfully registered'] = 'Rejestracja zakoczona pomylnie!';
$strings['Continue'] = 'Kontynuuj...';
$strings['Your profile has been successfully updated!'] = 'Twj profil zosta poprawnie uaktualniony!';
$strings['Please return to My Control Panel'] = 'Wr do panelu sterowania';
$strings['Valid email address is required.'] = '- Wymagany jest poprawny adres email.';
$strings['First name is required.'] = '- Wymagane imi.';
$strings['Last name is required.'] = '- Wymagane nazwisko.';
$strings['Phone number is required.'] = '- Wymagany numer telefonu.';
$strings['That email is taken already.'] = '- Ten adres email jest ju uywany.<br />Sprbuj ponownie z innym adresem email.';
$strings['Min 6 character password is required.'] = '- Potrzebna min. liczba %s znakw hasa.';
$strings['Passwords do not match.'] = '- Hasa nie s zgodne.';

$strings['Per page'] = 'Na stronie:';
$strings['Page'] = 'Strona:';

$strings['Your reservation was successfully created'] = 'Pomylnie utworzono rejestracj';
$strings['Your reservation was successfully modified'] = 'Pomylnie zmodyfikowano rejestracj';
$strings['Your reservation was successfully deleted'] = 'Pomylnie usunito rejestracj';
$strings['Your blackout was successfully created'] = 'Czas niedostpnoci zosta pomylnie utworzony';
$strings['Your blackout was successfully modified'] = 'Czas niedostpnoci zosta pomylnie zmodyfikowany';
$strings['Your blackout was successfully deleted'] = 'Czas niedostpnoci zosta pomylnie usunity';
$strings['for the follwing dates'] = 'dla nastpujcych dat:';
$strings['Start time must be less than end time'] = 'Czas rozpoczcia musi by mniejszy ni czas zakoczenia.';
$strings['Current start time is'] = 'Aktualny czas rozpoczcia:';
$strings['Current end time is'] = 'Aktualny czas zakoczenia:';
$strings['Reservation length does not fall within this resource\'s allowed length.'] = 'Dugo czasu rezerwacji nie zgadza si z dozwolon dugoci rezerwacji tego zasobu.';
$strings['Your reservation is'] = 'Twoja rezerwacja to:';
$strings['Minimum reservation length'] = 'Minimalna dugo rezerwacji:';
$strings['Maximum reservation length'] = 'Maksymalna dugo rezerwacji:';
$strings['You do not have permission to use this resource.'] = 'Nie masz uprawnie do uycia tego zasobu.';
$strings['reserved or unavailable'] = '%s do %s jest zarejestrowany lub niedostpny.';	// @since 1.1.0
$strings['Reservation created for'] = 'Rezerwacja utworzona dla %s';
$strings['Reservation modified for'] = 'Rezerwacja zmodyfikowana dla %s';
$strings['Reservation deleted for'] = 'Rezerwacja usunita dla %s';
$strings['created'] = 'utworzona';
$strings['modified'] = 'zmieniona';
$strings['deleted'] = 'usunita';
$strings['Reservation #'] = 'Rezerwacja #';
$strings['Contact'] = 'Kontakt';
$strings['Reservation created'] = 'Utworzono rezerwacj';
$strings['Reservation modified'] = 'Uaktualniono rezerwacj';
$strings['Reservation deleted'] = 'Usunito rezerwacj';

$strings['Reservations by month'] = 'Rezerwacje miesicznie';
$strings['Reservations by day of the week'] = 'Rezerwacje wedug dnia tygodnia';
$strings['Reservations per month'] = 'Rezerwacje miesicznie';
$strings['Reservations per user'] = 'Rezerwacje wedug uytkownika';
$strings['Reservations per resource'] = 'Rezerwacje wedug zasobu';
$strings['Reservations per start time'] = 'Rezerwacje wedug czasu pocztkowego';
$strings['Reservations per end time'] = 'Rezerwacje wedug czasu kocowego';
$strings['[All Reservations]'] = '[Wszystkie rezerwacje]';

$strings['Permissions Updated'] = 'Uaktualniono uprawnienia';
$strings['Your permissions have been updated'] = 'Twoje uprawnienia %s zostay zaktualizowane';
$strings['You now do not have permission to use any resources.'] = 'Nie masz uprawnie do uywania jakichkolwiek zasobw.';
$strings['You now have permission to use the following resources'] = 'Masz teraz uprawnienia do korzystania z nastpujcych zasobw:';
$strings['Please contact with any questions.'] = 'Skontaktuj si z %s w przypadku jakichkolwiek kwestii.';
$strings['Password Reset'] = 'Reset hasa';

$strings['This will change your password to a new, randomly generated one.'] = 'Ta operacja zmieni haso na nowe, losowo wygenerowane.';
$strings['your new password will be set'] = 'Po wprowadzeniu adresu email oraz klikniciu "Zmiana hasa", Twoje nowe haso zostanie ustawione w systemie i przesane Ci na adres email.';
$strings['Change Password'] = 'Zmiana hasa';
$strings['Sorry, we could not find that user in the database.'] = 'Niestety nie mona znale tego uytkownika w bazie danych.';
$strings['Your New Password'] = 'Twoje nowe haso %s';
$strings['Your new passsword has been emailed to you.'] = 'Sukces!<br />'
    			. 'Twoje nowe haso zostanie Ci przesane.<br />'
    			. 'Sprawd swoj skrzynk pocztow czy zawiera nowe haso na nastpnie <a href="index.php">Zaloguj si</a>'
    			. ' za jego pomoc i zmie je za porednictwem opcji &quot;Zmiana inoformacji profilu/hasa&quot;'
    			. ' znajdujcej si w panelu sterowania.';

$strings['You are not logged in!'] = 'Nie jeste zalogowana/zalogowany!';

$strings['Setup'] = 'Konfiguracja';
$strings['Please log into your database'] = 'Zaloguj si do swojej bazy danych';
$strings['Enter database root username'] = 'Enter database root username:';
$strings['Enter database root password'] = 'Enter database root password:';
$strings['Login to database'] = 'Login to database';
$strings['Root user is not required. Any database user who has permission to create tables is acceptable.'] = 'Root user is <b>not</b> required. Any database user who has permission to create tables is acceptable.';
$strings['This will set up all the necessary databases and tables for phpScheduleIt.'] = 'This will set up all the necessary databases and tables for phpScheduleIt.';
$strings['It also populates any required tables.'] = 'It also populates any required tables.';
$strings['Warning: THIS WILL ERASE ALL DATA IN PREVIOUS phpScheduleIt DATABASES!'] = 'Warning: THIS WILL ERASE ALL DATA IN PREVIOUS phpScheduleIt DATABASES!';
$strings['Not a valid database type in the config.php file.'] = 'Not a valid database type in the config.php file.';
$strings['Database user password is not set in the config.php file.'] = 'Database user password is not set in the config.php file.';
$strings['Database name not set in the config.php file.'] = 'Database name not set in the config.php file.';
$strings['Successfully connected as'] = 'Successfully connected as';
$strings['Create tables'] = 'Create tables &gt;';
$strings['There were errors during the install.'] = 'There were errors during the install. It is possible that phpScheduleIt will still work if the errors were minor.<br/><br/>'
	. 'Please post any questions to the forums on <a href="http://sourceforge.net/forum/?group_id=95547">SourceForge</a>.';
$strings['You have successfully finished setting up phpScheduleIt and are ready to begin using it.'] = 'You have successfully finished setting up phpScheduleIt and are ready to begin using it.';
$strings['Thank you for using phpScheduleIt'] = 'Please be sure to COMPLETELY REMOVE THE \'install\' DIRECTORY.'
	. ' This is critical because it contains database passwords and other sensitive information.'
	. ' Failing to do so leaves the door wide open for anyone to break into your database!'
	. '<br /><br />'
	. 'Thank you for using phpScheduleIt!';
$strings['There is no way to undo this action'] = 'Nie da si cofn tej operacji!';
$strings['Click to proceed'] = 'Kliknij aby kontynuowa';
$strings['Please delete this file.'] = 'Prosz usun ten plik.';
$strings['Successful update'] = 'Aktualizacja powioda si w peni';
$strings['Patch completed successfully'] = 'Pomylne zakoczenie aktualizacji aty';

// @since 1.0.0 RC1
$strings['If no value is specified, the default password set in the config file will be used.'] = 'If no value is specified, the default password set in the config file will be used.';
$strings['Notify user that password has been changed?'] = 'Powiadamia uytkownika, e haso zostao zaktualizowane?';

// @since 1.1.0
$strings['This system requires that you have an email address.'] = 'Ten system wymaga posiadania adresu email.';
$strings['Invalid User Name/Password.'] = 'Nieprawidowa nazwa uytkownika/haso.';
$strings['Pending User Reservations'] = 'Oczekujce rezerwacje uytkownikw';
$strings['Approve'] = 'Zaakceptuj';
$strings['Approve this reservation'] = 'Akceptacja tej rezerwacji';
$strings['Approve Reservations'] ='Akceptacja rezerwacji';

$strings['Announcement'] = 'Powiadomienie';
$strings['Number'] = 'Liczba';
$strings['Add Announcement'] = 'Dodaj powiadomienie';
$strings['Edit Announcement'] = 'Zmodyfikuj powiadomienie';
$strings['All Announcements'] = 'Wszystkie powiadomienia';
$strings['Delete Announcements'] = 'Usu powiadomienia';
$strings['Use start date/time?'] = 'Uy pocztkowej daty/czasu?';
$strings['Use end date/time?'] = 'Uy kocowej daty/czasu?';
$strings['Announcement text is required.'] = 'Tekst powiadomienia jest wymagany.';
$strings['Announcement number is required.'] = 'Numer powiadomienia jest wymagany.';

$strings['Pending Approval'] = 'Oczekujce akceptacje';
$strings['My reservation is approved'] = 'Moja rezerwacja zostaa zaakceptowana';
$strings['This reservation must be approved by the administrator.'] = 'Ta rezerwacja musi zosta zaakceptowana przez administratora.';
$strings['Approval Required'] = 'Wymagana akceptacja';
$strings['No reservations requiring approval'] = 'Brak rezerwacji wymagajcych akceptacji';
$strings['Your reservation was successfully approved'] = 'Twoja rezerwacja zostaa pomylnie zaakceptowana';
$strings['Reservation approved for'] = 'Zaakceptowano rezerwacj dla %s';
$strings['approved'] = 'zaakceptowane';
$strings['Reservation approved'] = 'Rezerwacja zaakceptowana';

$strings['Valid username is required'] = 'Wymagana jest poprawna nazwa uytkownika';
$strings['That logon name is taken already.'] = 'Ta nazwa uytkownika jest ju zajta.';
$strings['this will be your login'] = '(to bdzie Twj login)';
$strings['Logon name'] = 'Nazwa uytkownika';
$strings['Your logon name is'] = 'Twj login to %s';

$strings['Start'] = 'Pocztek';
$strings['End'] = 'Koniec';
$strings['Start date must be less than or equal to end date'] = 'Data pocztkowa musi by wczeniejsza lub rwna dacie kocowej';
$strings['That starting date has already passed'] = 'Ta data pocztkowa ju mina';
$strings['Basic'] = 'Podstawowy';
$strings['Participants'] = 'Czonkowie';
$strings['Close'] = 'Zamknij';
$strings['Start Date'] = 'Data pocz.';
$strings['End Date'] = 'Data koc.';
$strings['Minimum'] = 'Minimum';
$strings['Maximum'] = 'Maksimum';
$strings['Allow Multiple Day Reservations'] = 'Moliwe wielokrotne rezerwacje';
$strings['Invited Users'] = 'Zaproszeni uytkownicy';
$strings['Invite Users'] = 'Zapro uytkownikw';
$strings['Remove Participants'] = 'Usu wspuytkownikw';
$strings['Reservation Invitation'] = 'Zaproszenie do rezerwacji';
$strings['Manage Invites'] = 'Zarzdzaj zaproszeniami';
$strings['No invite was selected'] = 'Nie wybrano zaproszenia';
$strings['reservation accepted'] = 'Uytkownik %s zaakceptowa twoje zaproszenie na %s';
$strings['reservation declined'] = 'Uytkownik %s odrzuci twoje zaproszenie na %s';
$strings['Login to manage all of your invitiations'] = 'Zaloguj si aby zarzdza wszystkimi swoimi zaproszeniami';
$strings['Reservation Participation Change'] = 'Zmiana wspudziau rezerwacji';
$strings['My Invitations'] = 'Moje zaproszenia';
$strings['Accept'] = 'Zaakceptuj';
$strings['Decline'] = 'Odrzu';
$strings['Accept or decline this reservation'] = 'Zaakceptuj lub odrzu t rezerwacj';
$strings['My Reservation Participation'] = 'Mj udzia w rezerwacjach';
$strings['End Participation'] = 'Zakocz udzia';
$strings['Owner'] = 'Waciciel';
$strings['Particpating Users'] = 'Uytkownicy biorcy udzia';
$strings['No advanced options available'] = 'Brak opcji zaawansowanych';
$strings['Confirm reservation participation'] = 'Potwierd udzia w rezerwacji';
$strings['Confirm'] = 'Potwierd';
$strings['Do for all reservations in the group?'] = 'Zrobi to samo ze wszystkimi rezerwacjami w grupie?';

$strings['My Calendar'] = 'Mj kalendarz';
$strings['View My Calendar'] = 'Zobacz mj kalendarz';
$strings['Participant'] = 'Czonek';
$strings['Recurring'] = 'Powtrzenie';
$strings['Multiple Day'] = 'Wiele dni';
$strings['[today]'] = '[dzisiaj]';
$strings['Day View'] = 'Widok dzienny';
$strings['Week View'] = 'Widok tygodniowy';
$strings['Month View'] = 'Widok miesiczny';
$strings['Resource Calendar'] = 'Kalendarz zasobw';
$strings['View Resource Calendar'] = 'Kalendarz terminw';	// @since 1.2.0
$strings['Signup View'] = 'Widok logowania';

$strings['Select User'] = 'Wybierz uytkownika';
$strings['Change'] = 'Zmie';

$strings['Update'] = 'Uaktualnij';
$strings['phpScheduleIt Update is only available for versions 1.0.0 or later'] = 'Aktualizacja phpScheduleIt Update jest dostpna dopiero od wersji 1.0.0 lub wyszych';
$strings['phpScheduleIt is already up to date'] = 'phpScheduleIt jest w najnowszej wersji';
$strings['Migrating reservations'] = 'Migrowanie rezerwacji';

$strings['Admin'] = 'Administracja';
$strings['Manage Announcements'] = 'Powiadomienia';
$strings['There are no announcements'] = 'Brak powiadomie';
// end since 1.1.0

// @since 1.2.0
$strings['Maximum Participant Capacity'] = 'Maksymalna pojemno udziau';
$strings['Leave blank for unlimited'] = 'Puste pole przy braku ogranicze';
$strings['Maximum of participants'] = 'Ten zasb posiada maksymaln pojemno %s dla osb';
$strings['That reservation is at full capacity.'] = 'Ta rezerwacja ma ju pen pojemno.';
$strings['Allow registered users to join?'] = 'Pozwoli zarejestrowanym uytkownikom przyczy si?';
$strings['Allow non-registered users to join?'] = 'Pozwoli niezarejestrowanym uytkownikom przyczy si??';
$strings['Join'] = 'Przycz';
$strings['My Participation Options'] = 'Opcje mojego udziau';
$strings['Join Reservation'] = 'Pocz rezerwacj';
$strings['Join All Recurring'] = 'Pocz wszystkie powtrzenia';
$strings['You are not participating on the following reservation dates because they are at full capacity.'] = 'You are not participating on the following reservation dates because they are at full capacity.';
$strings['You are already invited to this reservation. Please follow participation instructions previously sent to your email.'] = 'You are already invited to this reservation. Please follow participation instructions previously sent to your email.';
$strings['Additional Tools'] = 'Dodatkowe narzdzia';
$strings['Create User'] = 'Utwrz uytkownika';
$strings['Check Availability'] = 'Sprawd dostpno';
$strings['Manage Additional Resources'] = 'Zarzdzaj sprztem';
$strings['All Additional Resources'] = 'Cae wyposaenie';
$strings['Number Available'] = 'Dostpna liczba';
$strings['Unlimited'] = 'Bez ogranicze';
$strings['Add Additional Resource'] = 'Dodaj sprzt';
$strings['Edit Additional Resource'] = 'Modyfikuj sprzt';
$strings['Checking'] = 'Sprawdzanie';
$strings['You did not select anything to delete.'] = 'Nie wybrano pozycji do usunicia.';
$strings['Added Resources'] = 'Dodane zasoby';
$strings['Additional resource is reserved'] = 'Dodatkowy zasb %s posiada dostpnych tylko %s w tym czasie';
$strings['All Groups'] = 'Wszystkie grupy';
$strings['Group Name'] = 'Nazwa grupy';
$strings['Delete Groups'] = 'Usu grupy';
$strings['Manage Groups'] = 'Zarzdzanie grupami';
$strings['None'] = 'Brak';
$strings['Group name is required.'] = 'Nazwa grupy jest wymagana.';
$strings['Groups'] = 'Grupy';
$strings['Current Groups'] = 'Aktualne grupy';
$strings['Group Administration'] = 'Administracja grupami';
$strings['Reminder Subject'] = 'Przypomnienie o rezerwacji- %s, %s %s';
$strings['Reminder'] = 'Przypomnienie';
$strings['before reservation'] = 'przed rezerwacj';
$strings['My Participation'] = 'Mj udzia';
$strings['My Past Participation'] = 'Mj przeszy udzia';
$strings['Timezone'] = 'Strefa czasowa';
$strings['Export'] = 'Wyeksportuj';
$strings['Select reservations to export'] = 'Wybierz rezerwacje do wyeksportowania';
$strings['Export Format'] = 'Format eksportu';
$strings['This resource cannot be reserved less than x hours in advance'] = 'Ten zasb nie moe zosta zarezerwowany mniej ni %s godzin naprzd';
$strings['This resource cannot be reserved more than x hours in advance'] = 'Ten zasb nie moe zosta zarejestrowany wczeniej ni %s godzin naprzd';
$strings['Minimum Booking Notice'] = 'Uwaga o minimalnym czasie rezerwacji';
$strings['Maximum Booking Notice'] = 'Uwaga o maksymalnym czasie rezerwacji';
$strings['hours prior to the start time'] = 'godzin przed pocztkiem';
$strings['hours from the current time'] = 'godzin od aktualnego czasu';
$strings['Contains'] = 'Zawiera';
$strings['Begins with'] = 'Zaczyna si od';
$strings['Minimum booking notice is required.'] = 'Uwaga o minimalnym czasie rezerwacji jest wymagana.';
$strings['Maximum booking notice is required.'] = 'Uwaga o maksymalnym czasie rezerwacji jest wymagana.';
$strings['Accessory Name'] = 'Nazwa sprztu';
$strings['Accessories'] = 'Sprzt';
$strings['All Accessories'] = 'Dostpny sprzt';
$strings['Added Accessories'] = 'Dodany sprzt';
// end since 1.2.0

/***
  EMAIL MESSAGES
  Please translate these email messages into your language.  You should keep the sprintf (%s) placeholders
   in their current position unless you know you need to move them.
  All email messages should be surrounded by double quotes "
  Each email message will be described below.
***/
// @since 1.1.0
// Email message that a user gets after they register
$email['register'] = "%s, %s \r\n"
				. "Uytkownik zosta dodany z nastpujcymi informacjami\r\n"
				. "Login: %s\r\n"
				. "Nazwa: %s %s \r\n"
				. "Telefon: %s \r\n"
				. "Instytucja: %s \r\n"
				. "Pozycja: %s \r\n\r\n"
				. "Prosz si zalogowa pod tym adresem:\r\n"
				. "%s \r\n\r\n"
				. "Mona znale odnoniki do internetowego terminarza aby zaktualizowa swj profil w Panelu administracyjnym.\r\n\r\n"
				. "Wszelkie pytania dotyczce zasobw lub rezerwacji kierowa do %s";

// Email message the admin gets after a new user registers
$email['register_admin'] = "Administratorze,\r\n\r\n"
					. "Nowy uytkownik z nastpujcymi informacjami:\r\n"
					. "Email: %s \r\n"
					. "Nazwa: %s %s \r\n"
					. "Telefon: %s \r\n"
					. "Instytucja: %s \r\n"
					. "Pozycja: %s \r\n\r\n";

// First part of the email that a user gets after they create/modify/delete a reservation
// 'reservation_activity_1' through 'reservation_activity_6' are all part of one email message
//  that needs to be assembled depending on different options.  Please translate all of them.
// @since 1.1.0
$email['reservation_activity_1'] = "%s,\r\n<br />"
			. "Pusiadasz pomylnie %s rezerwacj #%s.\r\n\r\n<br/><br/>"
			. "Uyj tego numeru rezerwacji podczas kontaktu z administratorem lub w razie posiadania jakich pyta.\r\n\r\n<br/><br/>"
			. "Rezerwacja pomidzy %s %s i %s %s dla %s"
			. " opisana jako %s zostaa %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_2'] = "Ta rezerwacja zostaa powtrzona dla nastpujcych dat:\r\n<br/>";
$email['reservation_activity_3'] = "Wszystkie powtrzone rezerwacje w tej grupie s take %s.\r\n\r\n<br/><br/>";
$email['reservation_activity_4'] = "Ponisze zestawienie zostao wypisane dla tej rezerwacji:\r\n<br/>%s\r\n\r\n<br/><br/>";
$email['reservation_activity_5'] = "Jeli to bd, skontaktuj si z administratorem pod adresem: %s"
			. " lub telefonicznie pod numerem %s.\r\n\r\n<br/><br/>"
			. "Mona przejrze lub zmodyfikowa dowoln informacj w dowolnym czasie poprzez "
			. " zalogowanie si do %s pod adresem:\r\n<br/>"
			. "<a href=\"%s\" target=\"_blank\">%s</a>.\r\n\r\n<br/><br/>";
$email['reservation_activity_6'] = "Kwestie techniczne naley kierowa do: <a href=\"mailto:%s\">%s</a>.\r\n\r\n<br/><br/>";
// @since 1.1.0
$email['reservation_activity_7'] = "%s,\r\n<br />"
			. "Rezerwacja #%s zostaa zaakceptowana.\r\n\r\n<br/><br/>"
			. "Uyj tego numeru rejestracyjnego podczas kontaktu z administratorem.\r\n\r\n<br/><br/>"
			. "Rezerwacja pomidzy %s %s oraz %s %s dla %s"
			. " opisana jako %s zostaa %s.\r\n\r\n<br/><br/>";

// Email that the user gets when the administrator changes their password
$email['password_reset'] = "Twoje haso %s zostao zresetowane przez administratora.\r\n\r\n"
			. "Twoje haso tymczasowe to:\r\n\r\n %s\r\n\r\n"
			. "Uyj tego tymczasowego hasa (skopiuj i wklej aby si upewni, e jest ono poprawne) i zaloguj si na %s pod adresem %s"
			. " nastpnie natychmiast zmie to haso przy uyciu zakadki 'Edycja profilu' w tabeli Odnoniki.\r\n\r\n"
			. "Skontaktuj si z administratorem %s w razie wtpliwoci.";

// Email that the user gets when they change their lost password using the 'Password Reset' form
$email['new_password'] = "%s,\r\n"
            . "Twoje nowe haso dla konta %s zostao:\r\n\r\n"
            . "%s\r\n\r\n"
            . "Zaloguj si pod adres %s "
            . "za pomoc tego hasa "
            . "(skopiuj je i wklej aby si upewni, e jest poprawne) "
            . "i zmie to haso poprzez kliknicie opcji "
            . "Edycja profilu "
            . "znajdujc si w panelu sterowania.\r\n\r\n"
            . "Wszystkie pytania kieruj bezporednio na adres %s.";

// @since 1.1.0
// Email that is sent to invite users to a reservation
$email['reservation_invite'] = "Uytkownik %s zaprosi Ci do udziau w poniszej rezerwacji:\r\n\r\n"
		. "Zasb: %s\r\n"
		. "Data rozpoczcia: %s\r\n"
		. "Czas rozpoczcia: %s\r\n"
		. "Data zakoczenia: %s\r\n"
		. "Czas zakoczenia: %s\r\n"
		. "Podsumowanie: %s\r\n"
		. "Powtarzajce si daty (jeli obecne): %s\r\n\r\n"
		. "Aby zaakceptowa to zaproszenie kliknij ten link (skopiuj i wklej jeli jest podwietlony) %s\r\n"
		. "Aby odrzuci to zaproszenie kliknij ten link (skopiuj i wklej jeli jest podwietlony) %s\r\n"
		. "Aby zaakceptowa wybrane daty i zarzdza swoimi zaproszeniami w czasie pniejszym, zaloguj si do systemu %s pod adresem %s";

// @since 1.1.0
// Email that is sent when a user is removed from a reservation
$email['reservation_removal'] = "Usunito nastpujc rezerwacj:\r\n\r\n"
		. "Zasb: %s\r\n"
		. "Data rozpoczcia: %s\r\n"
		. "Czas rozpoczcia: %s\r\n"
		. "Data zakoczenia: %s\r\n"
		. "Czas zakoczenia: %s\r\n"
		. "Podsumowanie: %s\r\n"
		. "Powtarzajce si daty (jeli obecne): %s\r\n\r\n";	

// @since 1.2.0
// Email body that is sent for reminders
$email['Reminder Body'] = "Twoja rezerwacja dla %s od %s %s do %s %s wkrtce si zblia.";
?>