<?php
/**
* This file contains the Location class for viewing
*
* @author Marco Antonio Frias B. <marcoantoniofrias@gmail.com>
* @version 05-30-11
* @package phpScheduleIt
*
* Copyright (C) 2011 Instituto Tecnologico INFOCAL Cochabamba
*/

$basedir = dirname(__FILE__) . '/..';

include_once($basedir . '/lib/db/LocationDB.class.php');

class Location {
	var $locationid;	// Properties
	var $name;			//
	var $location;		//
	var $status;		//

	var $err_msg = null;
	var $db;

	/**
	* Sets the locationid variable
	* @param string $locationid locations id
	*/
	function Location($locationid = null) {
		$this->locationid = $locationid;
		$this->db = new LocationDB();

		if (!empty($this->locationid)) {		// Load values
			$this->load_by_id();
		}
	}

	/**
	* Returns all data associated with this location
	* using their ID as the identifier
	* @param none
	* @return array of location data
	*/
	function load_by_id() {
		$data = $this->db->get_location_data($this->locationid);

		if (!$data) {
			$this->err_msg = $this->db->get_err();
			return;
		}

		$this->name		= $data['name'];
		$this->location	= $data['location'];
		$this->status	= $data['status'];

		unset($data);
	}

	/**
	* Returns the error message generated
	* @param none
	* @return error message as string
	*/
	function get_error() {
		return $this->err_msg;
	}

	function get_id() {
		return $this->locationid;
	}

	function get_name() {
		return $this->name;
	}

	function get_location() {
		return $this->location;
	}

	function get_status() {
		return $this->status;
	}
}
?>