<?php
/**
* This file contains the database class to work with the Location class
* @author Marco Antonio Frias B. <marcoantoniofrias@gmail.com>
* @version 05-30-11
* @package DBEngine
*
* Copyright (C) 2011 Instituto Tecnologico INFOCAL Cochabamba
*/
$basedir = dirname(__FILE__) . '/../..';

include_once($basedir . '/lib/DBEngine.class.php');

/**
* Provide functionality for getting and setting location data
*/
class LocationDB extends DBEngine {

	/**
	* Return all data associated with this locationid
	* @param string $locationid id of location to find
	* @return array of location data
	*/
	function get_location_data($locationid) {
		$result = $this->db->getRow('SELECT * FROM ' . $this->get_table(TBL_LOCATION) . ' WHERE locationid=?', array($locationid));
		$this->check_for_error($result);
		
		if (count($result) <= 0) {
			$this->err_msg = translate('That record could not be found.');
			return false;
		}
		
		return $this->cleanRow($result);
	}

	/**
	* Gets all information about the all locations filtering by status
	* @param string $location location of the resource
	* @param char $status status of location
	* @return array of location data filtering by status
	*/
	function get_locations($location, $status) {
		$locations = array();

		$query = 'SELECT * FROM ' . $this->get_table(TBL_LOCATION) . ' WHERE location = ? AND status = ?';

		$result = $this->db->query($query, array($location, $status));
		$this->check_for_error($result);

		while ($rs = $result->fetchRow()) {
			$locations[] = $rs;
		}

		return $locations;
	}
}
?>